package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 扫描上传 dto，或者在未识别完成的批次下追加一张影像
 * @author chong
 */
@Data
public class MsFileUploadRequest extends MsRecBaseRequest {
    @ApiModelProperty(value = "标识", required = true)
    private String reserved;
    @ApiModelProperty(value = "headFileId")
    private Long headFileId;
    @ApiModelProperty(value = "批次id", required = true)
    private Long batchId;
    @ApiModelProperty(value = "文件顺序", required = true)
    private Integer fileOrder;
    @ApiModelProperty(value = "是否需要识别Y-是，N-否", required = true)
    private String requiredOcrFlag;
    @ApiModelProperty(value = "来源：1-扫描，2-上传，3-对接接口，99-其他", required = true)
    private Integer source;
    @ApiModelProperty(value = "组织id", required = true)
    private Long orgId;
    @ApiModelProperty(value = "业务类型1-单据，2-发票，3-附件，99-其他")
    private Integer bizType;
    @ApiModelProperty(value = "自定义字段列表")
    private List<List<String>> tags;
    @ApiModelProperty(value = "url", required = true)
    private String fileUrl;
    @ApiModelProperty(value = "文件类型,文件扩展名")
    String fileType;
    @ApiModelProperty(value = "处理文件路径")
    private String fileUrlHandle;
    @ApiModelProperty(value = "处理文件类型(扩展名)，jpg,png,pdf,jpeg")
    private String fileTypeHandle;
    @ApiModelProperty(value = "客户端识别结果")
    String clientRecogResult;

}
