package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 扫描上传 dto，或者在未识别完成的批次下追加一张影像
 * @author chong
 */
@Data
public class MsFilesUploadRequest extends MsRecBaseRequest {
    @ApiModelProperty(value = "批次id", required = true)
    private Long batchId;
    @ApiModelProperty(value = "是否需要识别Y-是，N-否", required = true)
    private String requiredOcrFlag;
    @ApiModelProperty(value = "来源：1-扫描，2-上传，3-对接接口，99-其他", required = true)
    private Integer source;
    @ApiModelProperty(value = "组织id", required = true)
    private Long orgId;
    @ApiModelProperty(value = "filesUploadDtos")
    private List<FilesUploadDto > filesUploadDtos;
}
