package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author chong
 */
@ApiModel(description = "请求体")
@Data
public class MsFindUnSubmitFilesRequest extends MsRecBaseRequest {
    /**
     * 发票号码
     */
    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    /**
     * 开票日期开始
     */
    @ApiModelProperty(value = "开票日期开始", example = "1537181115916")
    private Date paperDrewDateStart;

    /**
     * 开票日期结束
     */
    @ApiModelProperty(value = "开票日期结束", example = "1537181115916")
    private Date paperDrewDateEnd;

    /**
     * 发票种类
     */
    @ApiModelProperty(value = "发票种类")
    private String invoiceType;

    /**
     * 开票日期结束
     */
    @ApiModelProperty(value = "轮询redis版本号", example = "1537181115916")
    private Date version;
}
