package com.xforceplus.phoenix.recog.api.model.invoice;

import com.xforceplus.phoenix.recog.api.model.file.VehicleInfoDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author chong
 */
@Data
public class InvoiceDto {
    @ApiModelProperty(value = "发票id")
    private Long id;
    @ApiModelProperty(value = "文件id"  ,required = true)
    private Long fileId;

    @ApiModelProperty(value = "单据号")
    private String billCode;

    @ApiModelProperty(value = "发票类型"  ,required = true)
    private String invoiceType;

    @ApiModelProperty(value = "影像类型"  ,required = true)
    private int bizType;

    @ApiModelProperty(value = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(value = "印刷发票代码")
    private String invoiceCodePrn;

    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    @ApiModelProperty(value = "印刷发票号码")
    private String invoiceNoPrn;

    @ApiModelProperty(value = "销方公司id")
    private Long sellerId;

    @ApiModelProperty(value = "销方纳税人识别号/身份证号")
    private String sellerTaxNo;

    @ApiModelProperty(value = "销方名称")
    private String sellerName;

    @ApiModelProperty(value = "销方地址、电话")
    private String sellerAddrTel;

    @ApiModelProperty(value = "销方开户行及账号")
    private String sellerBankInfo;

    @ApiModelProperty(value = "购方公司id")
    private String purchaserId;

    @ApiModelProperty(value = "购方纳税人识别号")
    private String purchaserTaxNo;

    @ApiModelProperty(value = "购方名称")
    private String purchaserName;

    @ApiModelProperty(value = "购方地址、电话")
    private String purchaserAddrTel;

    @ApiModelProperty(value = "购方开户行及账号")
    private String purchaserBankInfo;

    @ApiModelProperty(value = "税率")
    private String taxRate;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "不含税金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "含税金额大写")
    private String amountWithTaxChn;

    @ApiModelProperty(value = "发票开票日期", example = "")
    private Date paperDrewDate;

    @ApiModelProperty(value = "密文")
    private String cipherText;

    @ApiModelProperty(value = "机器编码")
    private String machineCode;

    @ApiModelProperty(value = "校验码")
    private String checkCode;

    @ApiModelProperty(value = "发票联次:1-发票联，2-抵扣联，9-其他")
    private String invoiceSheet;

    @ApiModelProperty(value = "查验ID")
    private Long checkId;

    @ApiModelProperty(value = "查验状态0-未查验，1-查验中，2-已查验")
    private Boolean checkStatus;

    @ApiModelProperty(value = "特殊发票标志")
    private String specialInvoiceFlag;

    @ApiModelProperty(value = "自定义字段值1")
    private String bizTag1;

    @ApiModelProperty(value = "自定义字段值2")
    private String bizTag2;

    @ApiModelProperty(value = "自定义字段值3")
    private String bizTag3;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "收款人")
    private String payee;

    @ApiModelProperty(value = "复核人")
    private String reviewer;

    @ApiModelProperty(value = "开票人")
    private String drawer;

    @ApiModelProperty(value = "创建时间,时间戳", example = "1537181115916")
    private Date createTime;

    @ApiModelProperty(value = "创建账号")
    private Long createUserId;

    @ApiModelProperty(value = "更新时间,时间戳", example = "1537181115916")
    private Date updateTime;

    @ApiModelProperty(value = "机动车统一销售发票信息")
    private VehicleInfoDto vehicleInfoDto;
}
