package com.xforceplus.phoenix.recog.api.model.invoice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * @author chong
 */
@ApiModel(
        description = "自定义修改发票信息"
)
@JsonInclude(Include.NON_NULL)
public class MsPimInvoiceField {
    @JsonProperty("fieldKey")
    private String fieldKey = null;
    @JsonProperty("fieldValue")
    private String fieldValue = null;

    public MsPimInvoiceField() {
    }

    @JsonIgnore
    public MsPimInvoiceField fieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
        return this;
    }

    @ApiModelProperty("修改字段KEY 取字段的驼峰格式命名 如:\"invoiceNo\"")
    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    @JsonIgnore
    public MsPimInvoiceField fieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    @ApiModelProperty("修改字段值")
    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o != null && this.getClass() == o.getClass()) {
            MsPimInvoiceField pimInvoiceField = (MsPimInvoiceField)o;
            return Objects.equals(this.fieldKey, pimInvoiceField.fieldKey) && Objects.equals(this.fieldValue, pimInvoiceField.fieldValue);
        } else {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldKey, this.fieldValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsPimInvoiceField {\n");
        sb.append("    fieldKey: ").append(this.toIndentedString(this.fieldKey)).append("\n");
        sb.append("    fieldValue: ").append(this.toIndentedString(this.fieldValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}
