package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票明细
 */
@ApiModel(description = "发票明细")

@JsonInclude(NON_NULL)
public class MSReceiveInvoiceDetail {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("cargoCode")
  private String cargoCode = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("vehiclePlateNum")
  private String vehiclePlateNum = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("vehicleTollDateFrom")
  private String vehicleTollDateFrom = null;

  @JsonProperty("vehicleTollDateEnd")
  private String vehicleTollDateEnd = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public MSReceiveInvoiceDetail invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票表rec_invoice表主键
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票表rec_invoice表主键")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail cargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
    return this;
  }

   /**
   * 货物或应税劳务代码
   * @return cargoCode
  **/
  @ApiModelProperty(value = "货物或应税劳务代码")
  public String getCargoCode() {
    return cargoCode;
  }

  public void setCargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物或应税劳务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail quantity(BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail taxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail unitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价")
  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail goodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
    return this;
  }

   /**
   * 编码版本号
   * @return goodsNoVer
  **/
  @ApiModelProperty(value = "编码版本号")
  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail vehiclePlateNum(String vehiclePlateNum) {
    this.vehiclePlateNum = vehiclePlateNum;
    return this;
  }

   /**
   * 车牌号
   * @return vehiclePlateNum
  **/
  @ApiModelProperty(value = "车牌号")
  public String getVehiclePlateNum() {
    return vehiclePlateNum;
  }

  public void setVehiclePlateNum(String vehiclePlateNum) {
    this.vehiclePlateNum = vehiclePlateNum;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail vehicleTollDateFrom(String vehicleTollDateFrom) {
    this.vehicleTollDateFrom = vehicleTollDateFrom;
    return this;
  }

   /**
   * 通行日期起
   * @return vehicleTollDateFrom
  **/
  @ApiModelProperty(value = "通行日期起")
  public String getVehicleTollDateFrom() {
    return vehicleTollDateFrom;
  }

  public void setVehicleTollDateFrom(String vehicleTollDateFrom) {
    this.vehicleTollDateFrom = vehicleTollDateFrom;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail vehicleTollDateEnd(String vehicleTollDateEnd) {
    this.vehicleTollDateEnd = vehicleTollDateEnd;
    return this;
  }

   /**
   * 通行日期止
   * @return vehicleTollDateEnd
  **/
  @ApiModelProperty(value = "通行日期止")
  public String getVehicleTollDateEnd() {
    return vehicleTollDateEnd;
  }

  public void setVehicleTollDateEnd(String vehicleTollDateEnd) {
    this.vehicleTollDateEnd = vehicleTollDateEnd;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建操作账号
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建操作账号")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 修改人
   * @return updateUserId
  **/
  @ApiModelProperty(value = "修改人")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MSReceiveInvoiceDetail status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 数据状态1-正常，9-删除
   * @return status
  **/
  @ApiModelProperty(value = "数据状态1-正常，9-删除")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSReceiveInvoiceDetail receiveInvoiceDetail = (MSReceiveInvoiceDetail) o;
    return Objects.equals(this.invoiceId, receiveInvoiceDetail.invoiceId) &&
        Objects.equals(this.cargoCode, receiveInvoiceDetail.cargoCode) &&
        Objects.equals(this.cargoName, receiveInvoiceDetail.cargoName) &&
        Objects.equals(this.itemSpec, receiveInvoiceDetail.itemSpec) &&
        Objects.equals(this.quantityUnit, receiveInvoiceDetail.quantityUnit) &&
        Objects.equals(this.quantity, receiveInvoiceDetail.quantity) &&
        Objects.equals(this.taxRate, receiveInvoiceDetail.taxRate) &&
        Objects.equals(this.unitPrice, receiveInvoiceDetail.unitPrice) &&
        Objects.equals(this.amountWithoutTax, receiveInvoiceDetail.amountWithoutTax) &&
        Objects.equals(this.taxAmount, receiveInvoiceDetail.taxAmount) &&
        Objects.equals(this.amountWithTax, receiveInvoiceDetail.amountWithTax) &&
        Objects.equals(this.goodsNoVer, receiveInvoiceDetail.goodsNoVer) &&
        Objects.equals(this.goodsTaxNo, receiveInvoiceDetail.goodsTaxNo) &&
        Objects.equals(this.vehiclePlateNum, receiveInvoiceDetail.vehiclePlateNum) &&
        Objects.equals(this.vehicleType, receiveInvoiceDetail.vehicleType) &&
        Objects.equals(this.vehicleTollDateFrom, receiveInvoiceDetail.vehicleTollDateFrom) &&
        Objects.equals(this.vehicleTollDateEnd, receiveInvoiceDetail.vehicleTollDateEnd) &&
        Objects.equals(this.createUserId, receiveInvoiceDetail.createUserId) &&
        Objects.equals(this.updateUserId, receiveInvoiceDetail.updateUserId) &&
        Objects.equals(this.status, receiveInvoiceDetail.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, cargoCode, cargoName, itemSpec, quantityUnit, quantity, taxRate, unitPrice, amountWithoutTax, taxAmount, amountWithTax, goodsNoVer, goodsTaxNo, vehiclePlateNum, vehicleType, vehicleTollDateFrom, vehicleTollDateEnd, createUserId, updateUserId, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSReceiveInvoiceDetail {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    cargoCode: ").append(toIndentedString(cargoCode)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    goodsNoVer: ").append(toIndentedString(goodsNoVer)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    vehiclePlateNum: ").append(toIndentedString(vehiclePlateNum)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    vehicleTollDateFrom: ").append(toIndentedString(vehicleTollDateFrom)).append("\n");
    sb.append("    vehicleTollDateEnd: ").append(toIndentedString(vehicleTollDateEnd)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
