package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.invoice.MsRecResultResponse;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author chong
 */
@Api(value = "recResultApi", description = "识别结果api")
public interface RecResultApi {

    /**
     * 影像识别回调
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "影像识别回调", notes = "影像识别回调", response = MsRecResultResponse.class, tags = {"recResultApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResultResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recResultApi/recResult", method = RequestMethod.POST)
    MsRecResultResponse recResult(@ApiParam(name = "影像识别回调", value = "json格式", required = true)
                                  @RequestBody String request);
}
