package com.xforceplus.phoenix.recog.api.common;

import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @author chong
 */
@ApiModel
@Data
public class Response<T> {
    public static final Integer OK = 1;
    public static final Integer FAIL = -1;
    private Integer code;
    private String message;
    private T result;

    public Response() {
    }

    public static Response ok(String message) {
        Response response = new Response();
        response.setCode(OK);
        response.setMessage(message);
        return response;
    }
    public static <T> Response ok(String message,T result) {
        Response response = new Response();
        response.setCode(OK);
        response.setMessage(message);
        response.result=result;
        return response;
    }
    public static Response failed(String message) {
        Response response = new Response();
        response.setCode(FAIL);
        response.setMessage(message);
        return response;
    }
    public static Response from(Integer code, String message) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> from(Integer code, String message, T result) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }
    @Override
    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}
