package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import com.xforceplus.phoenix.recog.api.model.RecPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author chong
 */
@ApiModel(description = "请求体")
@Data
public class MsFindSubmittedFilesRequest extends MsRecBaseRequest {
    @ApiModelProperty(value = "分页对象")
    private RecPage page;
    /**
     * 发票号码
     */
    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    /**
     * 开票日期开始
     */
    @ApiModelProperty(value = "开票日期开始", example = "1537181115916")
    private Date paperDrewDateStart;

    /**
     * 开票日期结束
     */
    @ApiModelProperty(value = "开票日期结束", example = "1537181115916")
    private Date paperDrewDateEnd;

    /**
     * 发票种类
     */
    @ApiModelProperty(value = "发票种类,发票类型100S-增值税专用发票，100C-增值税普通发票，10CE-增值税电子普通发票，10CJ增值税普通发票卷票，10CT通行费增值税电子普通发票,100J机动车统一销售发票，0000-单据")
    private String invoiceType;

    @ApiModelProperty(value = "报销状态：N-未报销，I-报销中，F-报销完成，E-报销失败，退回", required = true)
    private String reimburseStatus;


    @ApiModelProperty(value = "查询扩展", example = "{\"bizTag1\":null,\"bizTag2\":null,\"bizTag3\":null}")
    private QueryExtend queryExtend;

    @ApiModel(description = "查询扩展")
    @Data
    public static class QueryExtend extends MsFindUnSubmitFilesRequest.QueryExtend{

    }

}
