package com.xforceplus.phoenix.recog.api.model.file;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 火车票实体类
 *
 * @author XuChong
 * @date 2019-04-22 13:47
 */
@Data
public class TrainDto {

    @ApiModelProperty("火车票id")
    private Long id;

    @ApiModelProperty("发票id")
    private Long invoiceId;

    @ApiModelProperty("火车票编号 号码")
    private String trainNo;

    @ApiModelProperty("发车日期 乘车日期 20180903")
    private Date trainDate;

    @ApiModelProperty("发车日期 乘车日期 20180903")
    private String trainDateStr;

    @ApiModelProperty("车次")
    private String trains;

    @ApiModelProperty("票价")
    private BigDecimal price;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("证件号码")
    private String certificateNo;

    @ApiModelProperty("出发地")
    private String startStation;

    @ApiModelProperty("目的地")
    private String endStation;

    @ApiModelProperty("时间 23:47")
    private String trainTime;

    @ApiModelProperty("座位")
    private String seat;

    @ApiModelProperty("座位类型")
    private String seatType;


    public String getTrainDateStr() {
        return null == trainDate ? null : DateUtil.format(trainDate, DatePattern.PURE_DATE_PATTERN);
    }
}
