package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 部门
 */
@ApiModel(description = "部门")

@JsonInclude(NON_NULL)
public class MSSectionDTO {
  @JsonProperty("section")
  private String section = null;

  @JsonProperty("shareScale")
  private BigDecimal shareScale = null;

  @JsonIgnore
  public MSSectionDTO section(String section) {
    this.section = section;
    return this;
  }

   /**
   * 部门名称或代码
   * @return section
  **/
  @ApiModelProperty(value = "部门名称或代码")
  public String getSection() {
    return section;
  }

  public void setSection(String section) {
    this.section = section;
  }

  @JsonIgnore
  public MSSectionDTO shareScale(BigDecimal shareScale) {
    this.shareScale = shareScale;
    return this;
  }

   /**
   * 部门分摊比例
   * @return shareScale
  **/
  @ApiModelProperty(value = "部门分摊比例")
  public BigDecimal getShareScale() {
    return shareScale;
  }

  public void setShareScale(BigDecimal shareScale) {
    this.shareScale = shareScale;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSSectionDTO sectionDTO = (MSSectionDTO) o;
    return Objects.equals(this.section, sectionDTO.section) &&
        Objects.equals(this.shareScale, sectionDTO.shareScale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(section, shareScale);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSSectionDTO {\n");
    
    sb.append("    section: ").append(toIndentedString(section)).append("\n");
    sb.append("    shareScale: ").append(toIndentedString(shareScale)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
