package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.annotation.CompareField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author chong
 */
@Data
public class FileDetailDto extends FileInfoDto {
    //前端不用
    @ApiModelProperty(value = "提交到发票管理id")
    private Long submitPimId;
    @ApiModelProperty(value = "创建用户id")
    private Long createUserId;
    //发票池
    @ApiModelProperty(value = "购方名称")
    @CompareField
    private String purchaserName;
    @ApiModelProperty(value = "购方地址")
    @CompareField
    private String purchaserAddress;
    @ApiModelProperty(value = "购方电话")
    @CompareField
    private String purchaserTel;
    @ApiModelProperty(value = "购方地址、电话")
    @CompareField
    private String purchaserAddrTel;
    @ApiModelProperty(value = "购方开户行及账号")
    @CompareField
    private String purchaserBankInfo;
    @ApiModelProperty(value = "销方名称")
    @CompareField
    private String sellerName;
    @ApiModelProperty(value = "销方地址")
    @CompareField
    private String sellerAddress;
    @ApiModelProperty(value = "销方电话")
    @CompareField
    private String sellerTel;
    @ApiModelProperty(value = "销方地址、电话")
    @CompareField
    private String sellerAddrTel;
    @ApiModelProperty(value = "销方开户行及账号")
    @CompareField
    private String sellerBankInfo;
    @ApiModelProperty(value = "根组织id")
    private Long rootOrgId;
    @ApiModelProperty(value = "组织id")
    private Long orgId;
    @ApiModelProperty(value = "含税金额大写")
    @CompareField
    private String amountWithTaxChn;
    @ApiModelProperty(value = "收款人")
    @CompareField
    private String payee;
    @ApiModelProperty(value = "开票人")
    @CompareField
    private String drawer;
    @ApiModelProperty(value = "复核人")
    @CompareField
    private String reviewer;
    @ApiModelProperty(value = "识别结束时间")
    private Date recEndTime;
    @ApiModelProperty(value = "创建用户名")
    private String createUser;
}
