package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsRecBaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author chong
 */
@ApiModel(description = "请求体")
@Data
public class MsFindUnSubmitFilesRequest extends MsRecBaseRequest {
    /**
     * 发票号码
     */
    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    /**
     * 开票日期开始
     */
    @ApiModelProperty(value = "开票日期开始", example = "1537181115916")
    private Date paperDrewDateStart;

    /**
     * 开票日期结束
     */
    @ApiModelProperty(value = "开票日期结束", example = "1537181115916")
    private Date paperDrewDateEnd;

    /**
     * 发票种类
     */
    @ApiModelProperty(value = "发票种类")
    private String invoiceType;

    /**
     * 开票日期结束
     */
    @ApiModelProperty(value = "轮询redis版本号", example = "1537181115916")
    private Date version;

    @ApiModelProperty(value = "报销状态：N-未报销，I-报销中，F-报销完成，E-报销失败，退回", required = true)
    private String reimburseStatus;

    @ApiModelProperty(value = "特殊发票标志 0-非特殊发票；1-通行费；2-成品油；3-区块链", required = true)
    private String specialInvoiceFlag;

    @ApiModelProperty(value = "查询扩展", example = "{\"bizTag1\":null,\"bizTag2\":null,\"bizTag3\":null}")
    private QueryExtend queryExtend;

    @ApiModel(description = "查询扩展")
    @Data
    public static class QueryExtend{

        @ApiModelProperty(value = "自定义字段值1")
        private String bizTag1;

        @ApiModelProperty(value = "自定义字段值1")
        private String bizTag2;

        @ApiModelProperty(value = "自定义字段值1")
        private String bizTag3;

    }

}
