package com.xforceplus.phoenix.recog.api.model.file;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsRecogPimInvoiceFileInfo
 * @author chong
 */

@JsonInclude(NON_NULL)
@Data
public class MsRecogPimInvoiceFileInfo {
    @ApiModelProperty(value = "发票开票日期")
    private String paperDrewDate;
    @ApiModelProperty(value = "不含税金额")
    private String amountWithoutTax;
    @ApiModelProperty(value = "税额")
    private String taxAmount;
    @ApiModelProperty(value = "含税金额")
    private String amountWithTax;
    @ApiModelProperty(value = "购方税号")
    private String purchaserTaxNo;
    @ApiModelProperty(value = "销方税号")
    private String sellerTaxNo;
    @ApiModelProperty(value = "机器编号")
    private String machineCode;
    @ApiModelProperty(value = "校验码")
    private String checkCode;
    @ApiModelProperty(value = "密文")
    private String cipherText;
    @ApiModelProperty(value = "文件id")
    private Long recogInvoiceId;
    @ApiModelProperty(value = "业务单号")
    private String billCode;
    @ApiModelProperty(value = "备注")
    private String remark;
}
