/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.recog.api.common;

import io.swagger.annotations.ApiModel;

@ApiModel
public class Response<T> {
    public static final Integer OK = 1;
    public static final Integer FAIL = -1;
    private Integer code;
    private String message;
    private T result;

    public static Response ok(String message) {
        Response response = new Response();
        response.setCode(OK);
        response.setMessage(message);
        return response;
    }

    public static <T> Response ok(String message, T result) {
        Response<T> response = new Response<T>();
        response.setCode(OK);
        response.setMessage(message);
        response.result = result;
        return response;
    }

    public static Response failed(String message) {
        Response response = new Response();
        response.setCode(FAIL);
        response.setMessage(message);
        return response;
    }

    public static Response from(Integer code, String message) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> from(Integer code, String message, T result) {
        Response<T> response = new Response<T>();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }
}

