package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.model.MsPageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author chong
 */
@Data
public class MsFindFileRequest extends MsPageRequest {
    @ApiModelProperty(value = "文件id")
    private Long id;
    @ApiModelProperty(value = "文件id列表")
    private List<Long> idList;
    @ApiModelProperty(value = "扫描批次号")
    private Long batchId;
    @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
    private Integer bizType;
    @ApiModelProperty(value = "1-扫描，2-上传，3-对接接口，99-其他")
    private Integer source;
    @ApiModelProperty(value = "根组织id")
    private Long rootOrgId;
    @ApiModelProperty(value = "组织id")
    private Long orgId;
    @ApiModelProperty(value = " 商户分组名称")
    private String groupName;
    @ApiModelProperty(value = "是否需要识别：Y-需要，N-不需要")
    private String requireOcrFlag;
    @ApiModelProperty(value = "文件路径")
    private String fileUrl;
    @ApiModelProperty(value = "原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
    private String fileType;
    @ApiModelProperty(value = "parentId,0代表空，1代表顶级parentId")
    private Long parentId;
    @ApiModelProperty(value = "文件level")
    private Integer fileLevel;
    @ApiModelProperty(value = "单据序列，0代表空")
    private Long billSeq;
    @ApiModelProperty(value = "处理状态：N-未识别I-正在识别F-识别完成")
    private String recStatus;
    @ApiModelProperty(value = "挂接状态：N-未挂接F-已挂接")
    private String hangUpStatus;
    @ApiModelProperty(value = "识别任务编号")
    private String taskId;
    @ApiModelProperty(value = "提交到发票管理id")
    private Long submitPimId;
    @ApiModelProperty(value = "已提交标志N-未提交，Y-已提交")
    private String submittedFlag;
    @ApiModelProperty(value = "发票id")
    private Long invoiceId;
    @ApiModelProperty(value = "单据号")
    private String billCode;
    @ApiModelProperty(value = "发票类型100S-增值税专用发票，100C-增值税普通发票，10CE-增值税电子普通发票，10CJ增值税普通发票卷票，10CT通行费增值税电子普通发票,100J机动车统一销售发票，0000-单据")
    private String invoiceType;
    @ApiModelProperty(value = "发票代码")
    private String invoiceCode;
    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;
    @ApiModelProperty(value = "提交结果状态")
    private Integer submitStatus;
}
