package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.annotation.CompareField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author chong
 */
@Data
public class VehicleInfoDto {
    @ApiModelProperty("Id")
    private Long id;
    @ApiModelProperty("发票Id")
    private Long invoiceId;
    @ApiModelProperty("车辆类型")
    @CompareField
    private String vehicleType;
    @ApiModelProperty("厂牌型号")
    @CompareField
    private String vehicleBrand;
    @ApiModelProperty("厂牌型号")
    @CompareField
    private String productionArea;
    @ApiModelProperty("合格证号")
    @CompareField
    private String certificateNo;
    @ApiModelProperty("进口证明书编号")
    @CompareField
    private String importCertNo;
    @ApiModelProperty("商检单号")
    @CompareField
    private String inspectionNo;
    @ApiModelProperty("发动机号码")
    @CompareField
    private String engineNo;
    @ApiModelProperty("车辆识别代号/车架号码")
    @CompareField
    private String vin;
    @ApiModelProperty("吨位")
    @CompareField
    private String tonnage;
    @ApiModelProperty("限乘人数")
    @CompareField
    private Integer maxCapacity;
    @ApiModelProperty("主管税务机关名")
    @CompareField
    private String taxAuthName;
    @ApiModelProperty("主管税务机关代码")
    @CompareField
    private String taxAuthCode;
    @ApiModelProperty("主管税务机关及代码")
    @CompareField
    private String taxAuthNameCode;
    @ApiModelProperty("完税凭证号")
    @CompareField
    private String taxPaidProof;
    @ApiModelProperty("销方银行名称")
    @CompareField
    private String sellerBankName;
    @ApiModelProperty("销方银行账号")
    @CompareField
    private String sellerBankAccount;
    @ApiModelProperty("销方地址")
    @CompareField
    private String sellerAddr;
    @ApiModelProperty("销方电话")
    @CompareField
    private String sellerTel;
    @ApiModelProperty("银行账号")
    @CompareField
    private String hiddenAccount;
    @ApiModelProperty(value = "差异字段")
    private List<String> diffs = new ArrayList<>();
}
