package com.xforceplus.phoenix.recog.api;

import com.xforceplus.xplatframework.model.MSResponse;
import com.xforceplus.phoenix.recog.api.model.MSUserRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.cloud.netflix.feign.FeignClient;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "user", description = "the user API")
public interface UserApi {

    @ApiOperation(value = "用户信息", notes = "", response = MSResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "userApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "结果处理返回", response = MSResponse.class) })
    @RequestMapping(value = "/user/userinfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    MSResponse getUserTaxNum(@ApiParam(value = "查询用户详细信息"  ) @RequestBody MSUserRequest userRequest);

}
