package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 住友单据删除请求
 */
@ApiModel(description = "住友单据删除请求")

@JsonInclude(NON_NULL)
public class MSBillDeleteRequest {
  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("accountantNo")
  private String accountantNo = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MSBillDeleteRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 单据号
   * @return billNo
  **/
  @ApiModelProperty(value = "单据号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MSBillDeleteRequest accountantNo(String accountantNo) {
    this.accountantNo = accountantNo;
    return this;
  }

   /**
   * 会记凭证号
   * @return accountantNo
  **/
  @ApiModelProperty(value = "会记凭证号")
  public String getAccountantNo() {
    return accountantNo;
  }

  public void setAccountantNo(String accountantNo) {
    this.accountantNo = accountantNo;
  }

  @JsonIgnore
  public MSBillDeleteRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 分组Id
   * @return groupId
  **/
  @ApiModelProperty(value = "分组Id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSBillDeleteRequest billDeleteRequest = (MSBillDeleteRequest) o;
    return Objects.equals(this.billNo, billDeleteRequest.billNo) &&
        Objects.equals(this.accountantNo, billDeleteRequest.accountantNo) &&
        Objects.equals(this.groupId, billDeleteRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billNo, accountantNo, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSBillDeleteRequest {\n");
    
    sb.append("    billNo: ").append(toIndentedString(billNo)).append("\n");
    sb.append("    accountantNo: ").append(toIndentedString(accountantNo)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
