package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 识别结果
 */
@ApiModel(description = "识别结果")

@JsonInclude(NON_NULL)
public class MSDiscernResult {
  @JsonProperty("reserved")
  private Long reserved = null;

  @JsonProperty("taskId")
  private String taskId = null;

  @JsonProperty("discernType")
  private Integer discernType = null;

  @JsonProperty("discernStatus")
  private Integer discernStatus = null;

  @JsonProperty("discernResultType")
  private Integer discernResultType = null;

  @JsonProperty("documentType")
  private String documentType = null;

  @JsonProperty("discernResult")
  private String discernResult = null;

  @JsonIgnore
  public MSDiscernResult reserved(Long reserved) {
    this.reserved = reserved;
    return this;
  }

   /**
   * 文件fileId
   * @return reserved
  **/
  @ApiModelProperty(value = "文件fileId")
  public Long getReserved() {
    return reserved;
  }

  public void setReserved(Long reserved) {
    this.reserved = reserved;
  }

  @JsonIgnore
  public MSDiscernResult taskId(String taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * 任务编号
   * @return taskId
  **/
  @ApiModelProperty(value = "任务编号")
  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  @JsonIgnore
  public MSDiscernResult discernType(Integer discernType) {
    this.discernType = discernType;
    return this;
  }

   /**
   * 识别类型
   * @return discernType
  **/
  @ApiModelProperty(value = "识别类型")
  public Integer getDiscernType() {
    return discernType;
  }

  public void setDiscernType(Integer discernType) {
    this.discernType = discernType;
  }

  @JsonIgnore
  public MSDiscernResult discernStatus(Integer discernStatus) {
    this.discernStatus = discernStatus;
    return this;
  }

   /**
   * 识别状态
   * @return discernStatus
  **/
  @ApiModelProperty(value = "识别状态")
  public Integer getDiscernStatus() {
    return discernStatus;
  }

  public void setDiscernStatus(Integer discernStatus) {
    this.discernStatus = discernStatus;
  }

  @JsonIgnore
  public MSDiscernResult discernResultType(Integer discernResultType) {
    this.discernResultType = discernResultType;
    return this;
  }

   /**
   * 识别结果类型(旧版)
   * @return discernResultType
  **/
  @ApiModelProperty(value = "识别结果类型(旧版)")
  public Integer getDiscernResultType() {
    return discernResultType;
  }

  public void setDiscernResultType(Integer discernResultType) {
    this.discernResultType = discernResultType;
  }

  @JsonIgnore
  public MSDiscernResult documentType(String documentType) {
    this.documentType = documentType;
    return this;
  }

   /**
   * 识别结果类型(新版)
   * @return documentType
  **/
  @ApiModelProperty(value = "识别结果类型(新版)")
  public String getDocumentType() {
    return documentType;
  }

  public void setDocumentType(String documentType) {
    this.documentType = documentType;
  }

  @JsonIgnore
  public MSDiscernResult discernResult(String discernResult) {
    this.discernResult = discernResult;
    return this;
  }

   /**
   * 识别结果
   * @return discernResult
  **/
  @ApiModelProperty(value = "识别结果")
  public String getDiscernResult() {
    return discernResult;
  }

  public void setDiscernResult(String discernResult) {
    this.discernResult = discernResult;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSDiscernResult discernResult = (MSDiscernResult) o;
    return Objects.equals(this.reserved, discernResult.reserved) &&
        Objects.equals(this.taskId, discernResult.taskId) &&
        Objects.equals(this.discernType, discernResult.discernType) &&
        Objects.equals(this.discernStatus, discernResult.discernStatus) &&
        Objects.equals(this.discernResultType, discernResult.discernResultType) &&
        Objects.equals(this.documentType, discernResult.documentType) &&
        Objects.equals(this.discernResult, discernResult.discernResult);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reserved, taskId, discernType, discernStatus, discernResultType, documentType, discernResult);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSDiscernResult {\n");
    
    sb.append("    reserved: ").append(toIndentedString(reserved)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    discernType: ").append(toIndentedString(discernType)).append("\n");
    sb.append("    discernStatus: ").append(toIndentedString(discernStatus)).append("\n");
    sb.append("    discernResultType: ").append(toIndentedString(discernResultType)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    discernResult: ").append(toIndentedString(discernResult)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
