package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.recog.api.model.MSReceiveInvoiceDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * general Request object
 */
@ApiModel(description = "general Request object")

@JsonInclude(NON_NULL)
public class MSReceiveInvoiceRequest {
  @JsonProperty("userGroupId")
  private Long userGroupId = null;

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonProperty("recId")
  private String recId = null;

  @JsonProperty("imageUrl")
  private String imageUrl = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("paperDrewDateStr")
  private String paperDrewDateStr = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserBank")
  private String purchaserBank = null;

  @JsonProperty("purchaserBankNo")
  private String purchaserBankNo = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("documentType")
  private String documentType = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerBank")
  private String sellerBank = null;

  @JsonProperty("sellerBankNo")
  private String sellerBankNo = null;

  @JsonProperty("invoiceCodePrn")
  private String invoiceCodePrn = null;

  @JsonProperty("invoiceNoPrn")
  private String invoiceNoPrn = null;

  @JsonProperty("payee")
  private String payee = null;

  @JsonProperty("reviewer")
  private String reviewer = null;

  @JsonProperty("drawer")
  private String drawer = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("stamper")
  private String stamper = null;

  @JsonProperty("amountWithTaxChn")
  private String amountWithTaxChn = null;

  @JsonProperty("totalAmountTaxChinese")
  private BigDecimal totalAmountTaxChinese = null;

  @JsonProperty("cipherText")
  private List<String> cipherText = new ArrayList<String>();

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("invoiceSheet")
  private String invoiceSheet = null;

  @JsonProperty("uploadUserId")
  private Long uploadUserId = null;

  @JsonProperty("reserved")
  private String reserved = null;

  @JsonProperty("details")
  private List<MSReceiveInvoiceDetail> details = new ArrayList<MSReceiveInvoiceDetail>();

  @JsonIgnore
  public MSReceiveInvoiceRequest userGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
    return this;
  }

   /**
   * 用户所属集团ID
   * @return userGroupId
  **/
  @ApiModelProperty(value = "用户所属集团ID")
  public Long getUserGroupId() {
    return userGroupId;
  }

  public void setUserGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MSReceiveInvoiceRequest addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 所属组织ID数组
   * @return orgIds
  **/
  @ApiModelProperty(value = "所属组织ID数组")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest recId(String recId) {
    this.recId = recId;
    return this;
  }

   /**
   * 源ID
   * @return recId
  **/
  @ApiModelProperty(value = "源ID")
  public String getRecId() {
    return recId;
  }

  public void setRecId(String recId) {
    this.recId = recId;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest imageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

   /**
   * 影像文件URL
   * @return imageUrl
  **/
  @ApiModelProperty(value = "影像文件URL")
  public String getImageUrl() {
    return imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 影像所属的单据号
   * @return billNo
  **/
  @ApiModelProperty(value = "影像所属的单据号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票编号
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票编号")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest paperDrewDateStr(String paperDrewDateStr) {
    this.paperDrewDateStr = paperDrewDateStr;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDateStr
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDateStr() {
    return paperDrewDateStr;
  }

  public void setPaperDrewDateStr(String paperDrewDateStr) {
    this.paperDrewDateStr = paperDrewDateStr;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest purchaserBank(String purchaserBank) {
    this.purchaserBank = purchaserBank;
    return this;
  }

   /**
   * 购方开户行
   * @return purchaserBank
  **/
  @ApiModelProperty(value = "购方开户行")
  public String getPurchaserBank() {
    return purchaserBank;
  }

  public void setPurchaserBank(String purchaserBank) {
    this.purchaserBank = purchaserBank;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest purchaserBankNo(String purchaserBankNo) {
    this.purchaserBankNo = purchaserBankNo;
    return this;
  }

   /**
   * 购方开户行账号
   * @return purchaserBankNo
  **/
  @ApiModelProperty(value = "购方开户行账号")
  public String getPurchaserBankNo() {
    return purchaserBankNo;
  }

  public void setPurchaserBankNo(String purchaserBankNo) {
    this.purchaserBankNo = purchaserBankNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest documentType(String documentType) {
    this.documentType = documentType;
    return this;
  }

   /**
   * 类型新
   * @return documentType
  **/
  @ApiModelProperty(value = "类型新")
  public String getDocumentType() {
    return documentType;
  }

  public void setDocumentType(String documentType) {
    this.documentType = documentType;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 售方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "售方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 售方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "售方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 售方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "售方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 售方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "售方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest sellerBank(String sellerBank) {
    this.sellerBank = sellerBank;
    return this;
  }

   /**
   * 售方开户行
   * @return sellerBank
  **/
  @ApiModelProperty(value = "售方开户行")
  public String getSellerBank() {
    return sellerBank;
  }

  public void setSellerBank(String sellerBank) {
    this.sellerBank = sellerBank;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest sellerBankNo(String sellerBankNo) {
    this.sellerBankNo = sellerBankNo;
    return this;
  }

   /**
   * 售方开户行卡号
   * @return sellerBankNo
  **/
  @ApiModelProperty(value = "售方开户行卡号")
  public String getSellerBankNo() {
    return sellerBankNo;
  }

  public void setSellerBankNo(String sellerBankNo) {
    this.sellerBankNo = sellerBankNo;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest invoiceCodePrn(String invoiceCodePrn) {
    this.invoiceCodePrn = invoiceCodePrn;
    return this;
  }

   /**
   * 印刷发票代码
   * @return invoiceCodePrn
  **/
  @ApiModelProperty(value = "印刷发票代码")
  public String getInvoiceCodePrn() {
    return invoiceCodePrn;
  }

  public void setInvoiceCodePrn(String invoiceCodePrn) {
    this.invoiceCodePrn = invoiceCodePrn;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest invoiceNoPrn(String invoiceNoPrn) {
    this.invoiceNoPrn = invoiceNoPrn;
    return this;
  }

   /**
   * 印刷发票号码
   * @return invoiceNoPrn
  **/
  @ApiModelProperty(value = "印刷发票号码")
  public String getInvoiceNoPrn() {
    return invoiceNoPrn;
  }

  public void setInvoiceNoPrn(String invoiceNoPrn) {
    this.invoiceNoPrn = invoiceNoPrn;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest payee(String payee) {
    this.payee = payee;
    return this;
  }

   /**
   * 收款人
   * @return payee
  **/
  @ApiModelProperty(value = "收款人")
  public String getPayee() {
    return payee;
  }

  public void setPayee(String payee) {
    this.payee = payee;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest reviewer(String reviewer) {
    this.reviewer = reviewer;
    return this;
  }

   /**
   * 复核
   * @return reviewer
  **/
  @ApiModelProperty(value = "复核")
  public String getReviewer() {
    return reviewer;
  }

  public void setReviewer(String reviewer) {
    this.reviewer = reviewer;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest drawer(String drawer) {
    this.drawer = drawer;
    return this;
  }

   /**
   * 开票人
   * @return drawer
  **/
  @ApiModelProperty(value = "开票人")
  public String getDrawer() {
    return drawer;
  }

  public void setDrawer(String drawer) {
    this.drawer = drawer;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest stamper(String stamper) {
    this.stamper = stamper;
    return this;
  }

   /**
   * 销售方（章）
   * @return stamper
  **/
  @ApiModelProperty(value = "销售方（章）")
  public String getStamper() {
    return stamper;
  }

  public void setStamper(String stamper) {
    this.stamper = stamper;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest amountWithTaxChn(String amountWithTaxChn) {
    this.amountWithTaxChn = amountWithTaxChn;
    return this;
  }

   /**
   * 中文金额
   * @return amountWithTaxChn
  **/
  @ApiModelProperty(value = "中文金额")
  public String getAmountWithTaxChn() {
    return amountWithTaxChn;
  }

  public void setAmountWithTaxChn(String amountWithTaxChn) {
    this.amountWithTaxChn = amountWithTaxChn;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest totalAmountTaxChinese(BigDecimal totalAmountTaxChinese) {
    this.totalAmountTaxChinese = totalAmountTaxChinese;
    return this;
  }

   /**
   * 中文数字金额
   * @return totalAmountTaxChinese
  **/
  @ApiModelProperty(value = "中文数字金额")
  public BigDecimal getTotalAmountTaxChinese() {
    return totalAmountTaxChinese;
  }

  public void setTotalAmountTaxChinese(BigDecimal totalAmountTaxChinese) {
    this.totalAmountTaxChinese = totalAmountTaxChinese;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest cipherText(List<String> cipherText) {
    this.cipherText = cipherText;
    return this;
  }

  public MSReceiveInvoiceRequest addCipherTextItem(String cipherTextItem) {
    this.cipherText.add(cipherTextItem);
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public List<String> getCipherText() {
    return cipherText;
  }

  public void setCipherText(List<String> cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest invoiceSheet(String invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
    return this;
  }

   /**
   * 联次
   * @return invoiceSheet
  **/
  @ApiModelProperty(value = "联次")
  public String getInvoiceSheet() {
    return invoiceSheet;
  }

  public void setInvoiceSheet(String invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest uploadUserId(Long uploadUserId) {
    this.uploadUserId = uploadUserId;
    return this;
  }

   /**
   * 联次
   * @return uploadUserId
  **/
  @ApiModelProperty(value = "联次")
  public Long getUploadUserId() {
    return uploadUserId;
  }

  public void setUploadUserId(Long uploadUserId) {
    this.uploadUserId = uploadUserId;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest reserved(String reserved) {
    this.reserved = reserved;
    return this;
  }

   /**
   * 最长450个字符，调用方传入的业务数据(任意格式)
   * @return reserved
  **/
  @ApiModelProperty(value = "最长450个字符，调用方传入的业务数据(任意格式)")
  public String getReserved() {
    return reserved;
  }

  public void setReserved(String reserved) {
    this.reserved = reserved;
  }

  @JsonIgnore
  public MSReceiveInvoiceRequest details(List<MSReceiveInvoiceDetail> details) {
    this.details = details;
    return this;
  }

  public MSReceiveInvoiceRequest addDetailsItem(MSReceiveInvoiceDetail detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * Get details
   * @return details
  **/
  @ApiModelProperty(value = "")
  public List<MSReceiveInvoiceDetail> getDetails() {
    return details;
  }

  public void setDetails(List<MSReceiveInvoiceDetail> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSReceiveInvoiceRequest receiveInvoiceRequest = (MSReceiveInvoiceRequest) o;
    return Objects.equals(this.userGroupId, receiveInvoiceRequest.userGroupId) &&
        Objects.equals(this.orgIds, receiveInvoiceRequest.orgIds) &&
        Objects.equals(this.recId, receiveInvoiceRequest.recId) &&
        Objects.equals(this.imageUrl, receiveInvoiceRequest.imageUrl) &&
        Objects.equals(this.billNo, receiveInvoiceRequest.billNo) &&
        Objects.equals(this.invoiceNo, receiveInvoiceRequest.invoiceNo) &&
        Objects.equals(this.invoiceCode, receiveInvoiceRequest.invoiceCode) &&
        Objects.equals(this.invoiceType, receiveInvoiceRequest.invoiceType) &&
        Objects.equals(this.paperDrewDateStr, receiveInvoiceRequest.paperDrewDateStr) &&
        Objects.equals(this.purchaserTaxNo, receiveInvoiceRequest.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, receiveInvoiceRequest.purchaserName) &&
        Objects.equals(this.purchaserAddress, receiveInvoiceRequest.purchaserAddress) &&
        Objects.equals(this.purchaserTel, receiveInvoiceRequest.purchaserTel) &&
        Objects.equals(this.purchaserBank, receiveInvoiceRequest.purchaserBank) &&
        Objects.equals(this.purchaserBankNo, receiveInvoiceRequest.purchaserBankNo) &&
        Objects.equals(this.amountWithTax, receiveInvoiceRequest.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, receiveInvoiceRequest.amountWithoutTax) &&
        Objects.equals(this.taxAmount, receiveInvoiceRequest.taxAmount) &&
        Objects.equals(this.machineCode, receiveInvoiceRequest.machineCode) &&
        Objects.equals(this.documentType, receiveInvoiceRequest.documentType) &&
        Objects.equals(this.sellerName, receiveInvoiceRequest.sellerName) &&
        Objects.equals(this.sellerTaxNo, receiveInvoiceRequest.sellerTaxNo) &&
        Objects.equals(this.sellerAddress, receiveInvoiceRequest.sellerAddress) &&
        Objects.equals(this.sellerTel, receiveInvoiceRequest.sellerTel) &&
        Objects.equals(this.sellerBank, receiveInvoiceRequest.sellerBank) &&
        Objects.equals(this.sellerBankNo, receiveInvoiceRequest.sellerBankNo) &&
        Objects.equals(this.invoiceCodePrn, receiveInvoiceRequest.invoiceCodePrn) &&
        Objects.equals(this.invoiceNoPrn, receiveInvoiceRequest.invoiceNoPrn) &&
        Objects.equals(this.payee, receiveInvoiceRequest.payee) &&
        Objects.equals(this.reviewer, receiveInvoiceRequest.reviewer) &&
        Objects.equals(this.drawer, receiveInvoiceRequest.drawer) &&
        Objects.equals(this.remark, receiveInvoiceRequest.remark) &&
        Objects.equals(this.stamper, receiveInvoiceRequest.stamper) &&
        Objects.equals(this.amountWithTaxChn, receiveInvoiceRequest.amountWithTaxChn) &&
        Objects.equals(this.totalAmountTaxChinese, receiveInvoiceRequest.totalAmountTaxChinese) &&
        Objects.equals(this.cipherText, receiveInvoiceRequest.cipherText) &&
        Objects.equals(this.checkCode, receiveInvoiceRequest.checkCode) &&
        Objects.equals(this.invoiceSheet, receiveInvoiceRequest.invoiceSheet) &&
        Objects.equals(this.uploadUserId, receiveInvoiceRequest.uploadUserId) &&
        Objects.equals(this.reserved, receiveInvoiceRequest.reserved) &&
        Objects.equals(this.details, receiveInvoiceRequest.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userGroupId, orgIds, recId, imageUrl, billNo, invoiceNo, invoiceCode, invoiceType, paperDrewDateStr, purchaserTaxNo, purchaserName, purchaserAddress, purchaserTel, purchaserBank, purchaserBankNo, amountWithTax, amountWithoutTax, taxAmount, machineCode, documentType, sellerName, sellerTaxNo, sellerAddress, sellerTel, sellerBank, sellerBankNo, invoiceCodePrn, invoiceNoPrn, payee, reviewer, drawer, remark, stamper, amountWithTaxChn, totalAmountTaxChinese, cipherText, checkCode, invoiceSheet, uploadUserId, reserved, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSReceiveInvoiceRequest {\n");
    
    sb.append("    userGroupId: ").append(toIndentedString(userGroupId)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("    recId: ").append(toIndentedString(recId)).append("\n");
    sb.append("    imageUrl: ").append(toIndentedString(imageUrl)).append("\n");
    sb.append("    billNo: ").append(toIndentedString(billNo)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    paperDrewDateStr: ").append(toIndentedString(paperDrewDateStr)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserBank: ").append(toIndentedString(purchaserBank)).append("\n");
    sb.append("    purchaserBankNo: ").append(toIndentedString(purchaserBankNo)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerBank: ").append(toIndentedString(sellerBank)).append("\n");
    sb.append("    sellerBankNo: ").append(toIndentedString(sellerBankNo)).append("\n");
    sb.append("    invoiceCodePrn: ").append(toIndentedString(invoiceCodePrn)).append("\n");
    sb.append("    invoiceNoPrn: ").append(toIndentedString(invoiceNoPrn)).append("\n");
    sb.append("    payee: ").append(toIndentedString(payee)).append("\n");
    sb.append("    reviewer: ").append(toIndentedString(reviewer)).append("\n");
    sb.append("    drawer: ").append(toIndentedString(drawer)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    stamper: ").append(toIndentedString(stamper)).append("\n");
    sb.append("    amountWithTaxChn: ").append(toIndentedString(amountWithTaxChn)).append("\n");
    sb.append("    totalAmountTaxChinese: ").append(toIndentedString(totalAmountTaxChinese)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    invoiceSheet: ").append(toIndentedString(invoiceSheet)).append("\n");
    sb.append("    uploadUserId: ").append(toIndentedString(uploadUserId)).append("\n");
    sb.append("    reserved: ").append(toIndentedString(reserved)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
