package com.xforceplus.phoenix.recog.api.model.file;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author chong
 */
@Data
public class FileQueryDto {
    /**
     * 关键字查询（包含 发票代码 发票号码 业务单号）
     */
    @ApiModelProperty(value = "关键字查询")
    private String keyword;

    /**
     * 是否需要batchId排序
     */
    @ApiModelProperty(value = "是否需要batchId排序")
    private String needBatchOrderId;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")
    private Long userId;

    /**
     * 业务标签查询
     */
    @ApiModelProperty(value = "业务标签查询")
    private String businessTag;

    /**
     * 提交标识
     */
    @ApiModelProperty(value = "提交标识")
    private String submittedFlag;

    /**
     * 报销状态
     */
    @ApiModelProperty(value = "报销状态")
    private String reimburseStatus;


    /**
     * 批次号查询
     */
    @ApiModelProperty(value = "批次号查询")
    private Long batchId;

    /**
     * 开票日期开始
     */
    @ApiModelProperty(value = "开票日期开始", example = "1537181115916")
    private Date paperDrewDateStart;

    /**
     * 开票日期结束
     */
    @ApiModelProperty(value = "开票日期结束", example = "1537181115916")
    private Date paperDrewDateEnd;

    /**
     * 发票种类
     */
    @ApiModelProperty(value = "发票种类,发票类型100S-增值税专用发票，100C-增值税普通发票，10CE-增值税电子普通发票，10CJ增值税普通发票卷票，10CT通行费增值税电子普通发票,100J机动车统一销售发票，0000-单据")
    private String invoiceType;

    @ApiModelProperty(value = "特殊发票标志 0-非特殊发票；1-通行费；2-成品油；3-区块链", required = true)
    private String specialInvoiceFlag;

    @ApiModelProperty(value = "识别完成时间开始", example = "1537181115916")
    private Date recEndTimeStart;

    @ApiModelProperty(value = "识别完成时间结束", example = "1537181115916")
    private Date recEndTimeEnd;

}
