package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.common.Response;
import com.xforceplus.phoenix.recog.api.constant.MsResponseCode;
import lombok.Data;

/**
 * @author liuchunliang
 * @date 2020-12-07 15:26
 */
@Data
public class MsExportResponse<T> extends Response<T> {

    public MsExportResponse() {
        this.setCode(Response.OK);
        this.setMessage("ok");
    }

    public boolean isOk(MsExportResponse response) {
        return MsResponseCode.OK.equals(response.getCode());
    }

    public MsExportResponse<T> ok() {
        this.setCode(Response.OK);
        return this;
    }

    public MsExportResponse<T> error() {
        MsExportResponse<T> response = new MsExportResponse<>();
        response.setCode(Response.FAIL);
        response.setMessage("error");
        return response;
    }

    public MsExportResponse<T> error(String message) {
        MsExportResponse<T> response = this.error();
        response.setMessage(message);
        return response;
    }

    public MsExportResponse<T> error(int code, String message) {
        MsExportResponse<T> response = this.error(message);
        response.setCode(code);
        return response;
    }
}
