package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.MSBillDeleteRequest;
import com.xforceplus.phoenix.recog.api.model.MSBillUploadRequest;
import com.xforceplus.phoenix.recog.api.model.MSDiscernResult;
import com.xforceplus.xplatframework.model.MSResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.cloud.netflix.feign.FeignClient;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "bill", description = "the bill API")
public interface BillApi {

    @ApiOperation(value = "单据或发票识别结果回调(住友对私或对公台账需求)", notes = "", response = MSResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "BillApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "识别结果处理返回", response = MSResponse.class) })
    @RequestMapping(value = "/bill/discern/accept",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    MSResponse acceptDiscern(@ApiParam(value = "识别结果返回"  ) @RequestBody MSDiscernResult billDiscernResult);


    @ApiOperation(value = "单据删除（台账调用）", notes = "", response = MSResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "BillApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "结果处理返回", response = MSResponse.class) })
    @RequestMapping(value = "/bill/delete",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    MSResponse deleteBill(@ApiParam(value = "单据删除请求"  ) @RequestBody MSBillDeleteRequest billDeleteRequest);


    @ApiOperation(value = "上传单据（集成调用）", notes = "", response = MSResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "BillApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "上传结果", response = MSResponse.class) })
    @RequestMapping(value = "/bill/upload",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    MSResponse uploadBill(@ApiParam(value = "住友对私报销单据上传请求"  ) @RequestBody MSBillUploadRequest billUploadRequest);

}
