package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.batch.MsCompleteBatchRequest;
import com.xforceplus.phoenix.recog.api.model.batch.MsCompleteBatchResponse;
import com.xforceplus.phoenix.recog.api.model.batch.MsFetchBatchIdRequest;
import com.xforceplus.phoenix.recog.api.model.batch.MsFetchBatchIdResponse;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author chong
 */
@Api(value = "recBatchApi", description = "识别服务批次相关api")
public interface RecBatchApi {

    /**
     * 获取批次id
     * @param request
     * @return
     */
    @ApiOperation(value = "获取批次id", notes = "获取批次id", response = MsFetchBatchIdResponse.class, tags = {"recBatchApi"})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsFetchBatchIdResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApi/fetchBatchId", method = RequestMethod.POST)
    MsFetchBatchIdResponse fetchBatchId(@ApiParam(name = "", value = "json格式", required = true)
            @RequestBody MsFetchBatchIdRequest request);


    @ApiOperation(value = "完成批次", notes = "完成批次", response = MsCompleteBatchResponse.class, tags = {"recBatchApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsCompleteBatchResponse.class)})
    /**
     * 完成批次
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApia/completeBatch", method = RequestMethod.POST)
    MsCompleteBatchResponse completeBatch(@ApiParam(name = "完成批次请求参数", value = "json格式", required = true)
                                          @RequestBody MsCompleteBatchRequest request);

    @ApiOperation(value = "完成批次Job", notes = "完成批次Job", tags = {"recBatchApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回")})
    /**
     * 完成批次Job
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recBatchApia/completeBatchJob", method = RequestMethod.POST)
    void completeBatchJob();

}
