package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.MsRecResponse;
import com.xforceplus.phoenix.recog.api.model.invoice.*;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author chong
 */
public interface RecInvoiceApi {
    @ApiOperation(value = "修改购销方税号", notes = "修改购销方税号", response = MsUpdateInvoiceResponse.class, tags = {"recInvoiceApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsUpdateInvoiceResponse.class)})
    /**
     * 修改购销方税号
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recInvoiceApi/updateInvoice", method = RequestMethod.POST)
    MsUpdateInvoiceResponse updateInvoice(@ApiParam(name = "修改发票信息请求参数", value = "json格式", required = true)
                                          @RequestBody MsUpdateInvoiceRequest request);


    @ApiOperation(value = "发起发票验真", notes = "发起发票验真", response = MsRecResponse.class, tags = {"recInvoiceApi"}, httpMethod = "PUT", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResponse.class)})
    /**
     * 发起发票验真
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/ms/api/v1/recog/recInvoiceApi/verify-invoice", method = RequestMethod.PUT)
    MsRecResponse verifyInvoice(@ApiParam(name = "发票id列表", value = "json格式", required = true)
                                          @RequestBody MsVerifyInvoiceRequest request);



    @ApiOperation(value = "修改发票信息", notes = "修改发票信息", response = MsUpdateTypeResponse.class, tags = {"recInvoiceApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsUpdateTypeResponse.class)})
    /**
     * 修改发票信息
     *
     * @param request
     * @return
     */

    @RequestMapping(value = "/ms/api/v1/recog/recInvoiceApi/updateInvoiceType", method = RequestMethod.POST)
    MsUpdateTypeResponse updateInvoiceType(@ApiParam(name = "修改发票信息", value = "json格式", required = true)
                                           @RequestBody MsUpdateTypeRequest request);

    /**
     * 影像识别回调
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "影像识别回调", notes = "影像识别回调", response = MsRecResultResponse.class, tags = {"recInvoiceApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsRecResultResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recInvoiceApi/recResult", method = RequestMethod.POST)
    MsRecResultResponse recResult(@ApiParam(name = "修改发票类型", value = "json格式", required = true)
                                  @RequestBody MsRecResultRequest request);


    /**
     * 批量更新自定义字段
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "批量更新自定义字段", notes = "批量更新自定义字段", response = MsBizTagResponse.class, tags = {"recInvoiceApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsBizTagResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recInvoiceApi/updateBizTag", method = RequestMethod.POST)
    MsBizTagResponse updateBizTag(@ApiParam(name = "批量更新自定义字段请求参数", value = "json格式", required = true)
                                  @RequestBody MsBizTagRequest request);

    /**
     * 根据主档修改发票信息
     *
     * @param request
     * @return
     */
    @ApiOperation(value = "根据主档修改发票信息", notes = "根据主档修改发票信息", response = MsUpdateByPimResponse.class, tags = {"recInvoiceApi"}, httpMethod = "POST", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsUpdateByPimResponse.class)})
    @RequestMapping(value = "/ms/api/v1/recog/recInvoiceApi/updateInvoiceByPim", method = RequestMethod.POST)
    MsUpdateByPimResponse updateInvoiceByPim(MsUpdateByPimRequest request);
}



