package com.xforceplus.phoenix.recog.api;

import com.xforceplus.phoenix.recog.api.model.MSReceiveInvoiceRequest;
import com.xforceplus.xplatframework.model.MSResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.cloud.netflix.feign.FeignClient;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "recInvoiceReceive", description = "the recInvoiceReceive API")
public interface RecInvoiceReceiveApi {

    @ApiOperation(value = "影像发票接收接口", notes = "", response = MSResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "recInvoiceReceiveApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "认证响应对象", response = MSResponse.class) })
    @RequestMapping(value = "/recInvoiceReceive/upload",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    MSResponse upload(@ApiParam(value = "发票接收请求对象" ,required=true ) @RequestBody MSReceiveInvoiceRequest request);

}
