package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.recog.api.model.MSSectionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 住友对私报销单据上传请求
 */
@ApiModel(description = "住友对私报销单据上传请求")

@JsonInclude(NON_NULL)
public class MSBillUploadRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("createUserAccount")
  private String createUserAccount = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("orgId")
  private Long orgId = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("originalBillNo")
  private String originalBillNo = null;

  @JsonProperty("submitType")
  private Integer submitType = null;

  @JsonProperty("bussinessType")
  private Integer bussinessType = null;

  @JsonProperty("submitUserName")
  private String submitUserName = null;

  @JsonProperty("submitUserAccount")
  private String submitUserAccount = null;

  @JsonProperty("sections")
  private List<MSSectionDTO> sections = new ArrayList<MSSectionDTO>();

  @JsonProperty("invoiceUrls")
  private List<String> invoiceUrls = new ArrayList<String>();

  @JsonIgnore
  public MSBillUploadRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户编号
   * @return userId
  **/
  @ApiModelProperty(value = "用户编号")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MSBillUploadRequest userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户名
   * @return userName
  **/
  @ApiModelProperty(value = "用户名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MSBillUploadRequest createUserAccount(String createUserAccount) {
    this.createUserAccount = createUserAccount;
    return this;
  }

   /**
   * 用户账号
   * @return createUserAccount
  **/
  @ApiModelProperty(value = "用户账号")
  public String getCreateUserAccount() {
    return createUserAccount;
  }

  public void setCreateUserAccount(String createUserAccount) {
    this.createUserAccount = createUserAccount;
  }

  @JsonIgnore
  public MSBillUploadRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 分组Id
   * @return groupId
  **/
  @ApiModelProperty(value = "分组Id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MSBillUploadRequest orgId(Long orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * 用户所属组织Id
   * @return orgId
  **/
  @ApiModelProperty(value = "用户所属组织Id")
  public Long getOrgId() {
    return orgId;
  }

  public void setOrgId(Long orgId) {
    this.orgId = orgId;
  }

  @JsonIgnore
  public MSBillUploadRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 单据号
   * @return billNo
  **/
  @ApiModelProperty(value = "单据号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MSBillUploadRequest originalBillNo(String originalBillNo) {
    this.originalBillNo = originalBillNo;
    return this;
  }

   /**
   * 原单据号
   * @return originalBillNo
  **/
  @ApiModelProperty(value = "原单据号")
  public String getOriginalBillNo() {
    return originalBillNo;
  }

  public void setOriginalBillNo(String originalBillNo) {
    this.originalBillNo = originalBillNo;
  }

  @JsonIgnore
  public MSBillUploadRequest submitType(Integer submitType) {
    this.submitType = submitType;
    return this;
  }

   /**
   * 提交类型 1-新增、0-删除、2-更新
   * @return submitType
  **/
  @ApiModelProperty(value = "提交类型 1-新增、0-删除、2-更新")
  public Integer getSubmitType() {
    return submitType;
  }

  public void setSubmitType(Integer submitType) {
    this.submitType = submitType;
  }

  @JsonIgnore
  public MSBillUploadRequest bussinessType(Integer bussinessType) {
    this.bussinessType = bussinessType;
    return this;
  }

   /**
   * 业务类型 0-对公 1-对私
   * @return bussinessType
  **/
  @ApiModelProperty(value = "业务类型 0-对公 1-对私")
  public Integer getBussinessType() {
    return bussinessType;
  }

  public void setBussinessType(Integer bussinessType) {
    this.bussinessType = bussinessType;
  }

  @JsonIgnore
  public MSBillUploadRequest submitUserName(String submitUserName) {
    this.submitUserName = submitUserName;
    return this;
  }

   /**
   * 提交人姓名
   * @return submitUserName
  **/
  @ApiModelProperty(value = "提交人姓名")
  public String getSubmitUserName() {
    return submitUserName;
  }

  public void setSubmitUserName(String submitUserName) {
    this.submitUserName = submitUserName;
  }

  @JsonIgnore
  public MSBillUploadRequest submitUserAccount(String submitUserAccount) {
    this.submitUserAccount = submitUserAccount;
    return this;
  }

   /**
   * 提交人账号
   * @return submitUserAccount
  **/
  @ApiModelProperty(value = "提交人账号")
  public String getSubmitUserAccount() {
    return submitUserAccount;
  }

  public void setSubmitUserAccount(String submitUserAccount) {
    this.submitUserAccount = submitUserAccount;
  }

  @JsonIgnore
  public MSBillUploadRequest sections(List<MSSectionDTO> sections) {
    this.sections = sections;
    return this;
  }

  public MSBillUploadRequest addSectionsItem(MSSectionDTO sectionsItem) {
    this.sections.add(sectionsItem);
    return this;
  }

   /**
   * 所属部门列表
   * @return sections
  **/
  @ApiModelProperty(value = "所属部门列表")
  public List<MSSectionDTO> getSections() {
    return sections;
  }

  public void setSections(List<MSSectionDTO> sections) {
    this.sections = sections;
  }

  @JsonIgnore
  public MSBillUploadRequest invoiceUrls(List<String> invoiceUrls) {
    this.invoiceUrls = invoiceUrls;
    return this;
  }

  public MSBillUploadRequest addInvoiceUrlsItem(String invoiceUrlsItem) {
    this.invoiceUrls.add(invoiceUrlsItem);
    return this;
  }

   /**
   * 发票影像
   * @return invoiceUrls
  **/
  @ApiModelProperty(value = "发票影像")
  public List<String> getInvoiceUrls() {
    return invoiceUrls;
  }

  public void setInvoiceUrls(List<String> invoiceUrls) {
    this.invoiceUrls = invoiceUrls;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSBillUploadRequest billUploadRequest = (MSBillUploadRequest) o;
    return Objects.equals(this.userId, billUploadRequest.userId) &&
        Objects.equals(this.userName, billUploadRequest.userName) &&
        Objects.equals(this.createUserAccount, billUploadRequest.createUserAccount) &&
        Objects.equals(this.groupId, billUploadRequest.groupId) &&
        Objects.equals(this.orgId, billUploadRequest.orgId) &&
        Objects.equals(this.billNo, billUploadRequest.billNo) &&
        Objects.equals(this.originalBillNo, billUploadRequest.originalBillNo) &&
        Objects.equals(this.submitType, billUploadRequest.submitType) &&
        Objects.equals(this.bussinessType, billUploadRequest.bussinessType) &&
        Objects.equals(this.submitUserName, billUploadRequest.submitUserName) &&
        Objects.equals(this.submitUserAccount, billUploadRequest.submitUserAccount) &&
        Objects.equals(this.sections, billUploadRequest.sections) &&
        Objects.equals(this.invoiceUrls, billUploadRequest.invoiceUrls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, userName, createUserAccount, groupId, orgId, billNo, originalBillNo, submitType, bussinessType, submitUserName, submitUserAccount, sections, invoiceUrls);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSBillUploadRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    createUserAccount: ").append(toIndentedString(createUserAccount)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    billNo: ").append(toIndentedString(billNo)).append("\n");
    sb.append("    originalBillNo: ").append(toIndentedString(originalBillNo)).append("\n");
    sb.append("    submitType: ").append(toIndentedString(submitType)).append("\n");
    sb.append("    bussinessType: ").append(toIndentedString(bussinessType)).append("\n");
    sb.append("    submitUserName: ").append(toIndentedString(submitUserName)).append("\n");
    sb.append("    submitUserAccount: ").append(toIndentedString(submitUserAccount)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("    invoiceUrls: ").append(toIndentedString(invoiceUrls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
