package com.xforceplus.phoenix.recog.api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 用户查询请求
 */
@ApiModel(description = "用户查询请求")

@JsonInclude(NON_NULL)
public class MSUserRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("extraInfo")
  private Integer extraInfo = null;

  @JsonIgnore
  public MSUserRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MSUserRequest extraInfo(Integer extraInfo) {
    this.extraInfo = extraInfo;
    return this;
  }

   /**
   * extraInfo
   * @return extraInfo
  **/
  @ApiModelProperty(value = "extraInfo")
  public Integer getExtraInfo() {
    return extraInfo;
  }

  public void setExtraInfo(Integer extraInfo) {
    this.extraInfo = extraInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MSUserRequest userRequest = (MSUserRequest) o;
    return Objects.equals(this.userId, userRequest.userId) &&
        Objects.equals(this.extraInfo, userRequest.extraInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, extraInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MSUserRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
