package com.xforceplus.phoenix.recog.api.model.file;

import com.xforceplus.phoenix.recog.api.annotation.CompareField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author chong
 */
@Data
public class FileInfoDto {
    @ApiModelProperty(value = "文件id")
    private Long id;
    @ApiModelProperty(value = "扫描批次号")
    private Long batchId;
    @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
    private Integer bizType;
    @ApiModelProperty(value = "类型:0-对公,1-对私")
    private Integer businessType;
    @ApiModelProperty(value = "1-扫描，2-上传，3-对接接口，99-其他")
    private Integer source;
    @ApiModelProperty(value = "原始文件路径")
    private String fileUrl;
    @ApiModelProperty(value = "原始文件类型(扩展名)，jpg,png,pdf,jpeg")
    private String fileType;
    @ApiModelProperty(value = "处理文件路径(缩略图)")
    private String fileUrlHandle;
    @ApiModelProperty(value = "parentId,0代表空，1代表顶级parentId")
    private Long parentId;
    @ApiModelProperty(value = "文件level")
    private Integer fileLevel;
    @ApiModelProperty(value = "文件顺序")
    private Integer fileOrder;
    @ApiModelProperty(value = "单据序列，0代表空")
    private Long billSeq;
    @ApiModelProperty(value = "发票序列，0代表空")
    private Long invoiceSeq;
    @ApiModelProperty(value = "附件序列，0代表空")
    private Long attachmentSeq;
    @ApiModelProperty(value = "处理状态：N-未识别I-正在识别F-识别完成")
    private String recStatus;
    @ApiModelProperty(value = "验签(0-默认(不展示),1-验签成功,2-文件篡改,3-无法验证)")
    private Integer validate;
    @ApiModelProperty(value = "识别任务编号")
    private String taskId;
    @ApiModelProperty(value = "发票id")
    private Long invoiceId;
    @ApiModelProperty(value = "单据号")
    @CompareField
    private String billCode;
    /**
     * 用户特性标记 1 住友
     */
    private Integer userFeatureFlag;
    @ApiModelProperty(value = "(住友)单据号重复标志位0-无，1-有")
    private Integer billCodeDuplicateFlag;
    @ApiModelProperty(value = "(住友)会记记账凭证号重复标志位0-无，1-有")
    private Integer accountantNoDuplicateFlag;
    /**
     * 住友：和影像已提交的对比
     * 麦当劳：和发票池对比，1：重复，同租户的重复 2：异常重复：不同租户的重复
     */
    @ApiModelProperty(value = "发票重复标志位0-无，1-重复，2-重复异常")
    private String invoiceDuplicateFlag;
    @ApiModelProperty(value = "(住友)部门权限异常标志位0-正常，1-无权限")
    private Integer sectionWrongFlag;

    @ApiModelProperty(value = "标签修改异常 1-正常 0-异常（不能修改）")
    private Integer isTagNormal;

    @ApiModelProperty(value = "标签修改异常提示")
    private String  tagErrorMsg;
    /**
     * 不可修改
     */
    @ApiModelProperty(value = "会计记账凭证号")
    private String accountantNo;
    @ApiModelProperty(value = "公司代码")
    private String companyCode;
    @ApiModelProperty(value = "部门代码")
    private String section;
    @ApiModelProperty(value = "会计年度")
    private String accountantYear;
    @ApiModelProperty(value = "供应商代码")
    private String supplierCode;
    @ApiModelProperty(value = "供应商名称")
    private String supplierName;
    @ApiModelProperty(value = "BI应付金额")
    private BigDecimal billAmount;

    @ApiModelProperty(value = "增值税专用发票s,增值税普通发票c,增值税电子普通发票ce,增值税普通发票（卷票）ju ,通行费增值税电子普通发票ct,机动车统一销售发票v")
    @CompareField
    private String invoiceType;
    @ApiModelProperty(value = "发票代码")
    @CompareField
    private String invoiceCode;
    @ApiModelProperty(value = "发票代码（印刷版）")
    @CompareField
    private String invoiceCodePrn;
    @ApiModelProperty(value = "发票号码")
    @CompareField
    private String invoiceNo;
    @ApiModelProperty(value = "发票号码（印刷版）")
    @CompareField
    private String invoiceNoPrn;
    @ApiModelProperty(value = "销方纳税人识别号/身份证号")
    @CompareField
    private String sellerTaxNo;
    @ApiModelProperty(value = "购方纳税人识别号")
    @CompareField
    private String purchaserTaxNo;
    @ApiModelProperty(value = "税率")
    @CompareField
    private String taxRate;
    @ApiModelProperty(value = "税额")
    @CompareField
    private BigDecimal taxAmount;
    @ApiModelProperty(value = "不含税金额")
    @CompareField
    private BigDecimal amountWithoutTax;
    @ApiModelProperty(value = "含税金额")
    @CompareField
    private BigDecimal amountWithTax;
    @ApiModelProperty(value = "发票开票日期,格式yyyyMMdd", example = "20180101")
    @CompareField
    private Date paperDrewDate;
    @ApiModelProperty(value = "密文")
    @CompareField
    private String cipherText;
    @ApiModelProperty(value = "机器编码")
    @CompareField
    private String machineCode;
    @ApiModelProperty(value = "校验码")
    @CompareField
    private String checkCode;
    @ApiModelProperty(value = "发票联次:1-发票联，2-抵扣联，9-其他")
    @CompareField
    private String invoiceSheet;
    @ApiModelProperty(value = "查验ID")
    private Long checkId;
    @ApiModelProperty(value = "0-验真中;1--验真成功;2--验真失败;3-验真请求发送失败，99-未查验")
    private Integer checkStatus;
    @ApiModelProperty(value = "查验消息")
    private String checkInfo;
    @ApiModelProperty(value = "业务标签")
    private String businessTag;
    @ApiModelProperty(value = "自定义字段json")
    private String bizTags;
    @ApiModelProperty(value = "自定义字段值1")
    @CompareField
    private String bizTag1;
    @ApiModelProperty(value = "自定义字段值2")
    @CompareField
    private String bizTag2;
    @ApiModelProperty(value = "自定义字段值3")
    @CompareField
    private String bizTag3;
    @ApiModelProperty(value = "备注")
    @CompareField
    private String remark;
    @ApiModelProperty(value = "报销退回原因、报销备注")
    private String reimburseRemark;
    @ApiModelProperty(value = "发票来源 1：影像识别 2：国信识别")
    @CompareField
    private Integer invoiceSource;
    @ApiModelProperty(value = "特殊发票标记  0-默认 1-通行费 2-成品油 3-区块链发票")
    @CompareField
    private String specialInvoiceFlag;

    @ApiModelProperty(value = "机动车票-扩展信息")
    private VehicleInfoDto vehicleInfoDto;
    @ApiModelProperty(value = "火车票-扩展信息")
    private TrainDto trainDto;
    @ApiModelProperty(value = "飞机票-扩展信息")
    private PlaneDto planeDto;

    @ApiModelProperty(value = "数据权限标志位0-无，1-有")
    private Integer dataPermissionFlag;
    @ApiModelProperty(value = "子文件")
    private List<FileInfoDto> subFiles = new ArrayList<>();

    @ApiModelProperty(value = "文件数量")
    private Integer fileCount;
    @ApiModelProperty(value = "发票数量")
    private Integer invoiceCount;
    @ApiModelProperty(value = "单据（对私）分摊比例")
    private String shareScale;
    @ApiModelProperty(value = "提交人账号（对私单据）")
    private String submitUserAccount;
    @ApiModelProperty(value = "提交人名称（对私单据）")
    private String submitUserName;
    @ApiModelProperty(value = "创建时间（扫描时间）")
    private String createTime;
    @ApiModelProperty(value = "识别完成时间", example = "1537181115916")
    private Date recEndTime;
    @ApiModelProperty(value = "3:购方信息不一致")
    private String complianceInfo;
}
