package com.xforceplus.phoenix.recog.api.model.file;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 飞机票，行程单实体类
 *
 * @author XuChong
 * @date 2019-04-22 14:10
 */
@Data
public class PlaneDto {

    @ApiModelProperty("飞机票id")
    private Long id;

    @ApiModelProperty("发票id")
    private Long invoiceId;

    @ApiModelProperty("旅客姓名")
    private String nameOfPassenger;

    @ApiModelProperty("证件号")
    private String cardNo;

    @ApiModelProperty("电子客票号码")
    private String eTicketNo;

    @ApiModelProperty("提示信息")
    private String information;

    @ApiModelProperty("销售单位代码")
    private String agentCode;

    @ApiModelProperty("填开日期 20180903")
    private Date dateOfIssue;

    @ApiModelProperty("填开日期 20180903")
    private String dateOfIssueStr;

    @ApiModelProperty("机场建设费")
    private BigDecimal caacDevelopmentFund;

    @ApiModelProperty("其他税费")
    private BigDecimal tax;

    @ApiModelProperty("印刷序号")
    private String serialNo;

    @ApiModelProperty("签注备注")
    private String endorsements;

    @ApiModelProperty("验证码")
    private String checkCode;

    @ApiModelProperty("保险费")
    private BigDecimal insurance;

    @ApiModelProperty("填开单位")
    private String issuedBy;

    @ApiModelProperty("票价")
    private BigDecimal fare;

    @ApiModelProperty("燃油附加费")
    private BigDecimal fuelSurcharge;

    @ApiModelProperty("总额合计")
    private BigDecimal totalAmount;

    @ApiModelProperty("飞机票明细信息")
    private List<PlaneItemDto> planeItems;

    public String getDateOfIssueStr() {
        return null == dateOfIssue ? null : DateUtil.format(dateOfIssue, DatePattern.PURE_DATE_PATTERN);
    }
}
