package com.xforceplus.phoenix.recog.api.model.file;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 行程单明细实体类
 *
 * @author XuChong
 * @date 2019-04-22 14:17
 */
@Data
public class PlaneItemDto {

    @ApiModelProperty("飞机票明细id")
    private Long Id;

    @ApiModelProperty("飞机票id")
    private Long planeId;

    @ApiModelProperty("出发站")
    private String planeFrom;

    @ApiModelProperty("目的地")
    private String planeTo;

    @ApiModelProperty("承运人")
    private String carrier;

    @ApiModelProperty("航班号")
    private String flight;

    @ApiModelProperty("座位等级")
    private String seatClass;

    @ApiModelProperty("日期 例：20180903")
    private Date planeDate;

    @ApiModelProperty("日期 例：20180903")
    private String planeDateStr;

    @ApiModelProperty("时间 例：23:47")
    private String planeTime;

    @ApiModelProperty("客票级别/客票类别")
    private String fareBasis;

    @ApiModelProperty("客票生效日期")
    private Date notValidBefore;

    @ApiModelProperty("客票失效日期")
    private Date notValidAfter;

    @ApiModelProperty("免费行李")
    private String allow;

    public String getPlaneDateStr() {
        return null == planeDate ? null : DateUtil.format(planeDate, DatePattern.PURE_DATE_PATTERN);
    }
}
