package com.xforceplus.phoenix.recog.api.model.invoice;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
/**
 * @author chong
 */
@ApiModel(value = "VehicleInvoiceDto")
@Data
public class VehicleInvoiceDto extends InvoiceDto {
    @ApiModelProperty(value = "发票id")
    private Long id;

   @ApiModelProperty(value = "INVOICE_ID")
    private Long invoiceId;

    @ApiModelProperty(value = "车辆类型")
    private String vehicleType;

    @ApiModelProperty(value = "厂牌型号")
    private String vehicleBrand;

    @ApiModelProperty(value = "产地")
    private String productionArea;

    @ApiModelProperty(value = "合格证号")
    private String certificateNo;

    @ApiModelProperty(value = "进口证明书编号")
    private String importCertNo;

    @ApiModelProperty(value = "商检单号")
    private String inspectionNo;

    @ApiModelProperty(value = "发动机号码")
    private String engineNo;

    @ApiModelProperty(value = "车辆识别代号/车架号码")
    private String vin;

    @ApiModelProperty(value = "吨位")
    private String tonnage;

   @ApiModelProperty(value = "限乘人数")
    private Integer maxCapacity;

    @ApiModelProperty(value = "主管税务机关名")
    private String taxAuthName;

   @ApiModelProperty(value = "主管税务机关代码")
    private String taxAuthCode;

   @ApiModelProperty(value = "主管税务机关及代码")
    private String taxAuthNameCode;

    @ApiModelProperty(value = "完税凭证号")
    private String taxPaidProof;

   @ApiModelProperty(value = "销方银行名称")
    private String sellerBankName;

    @ApiModelProperty(value = "销方银行账号")
    private String sellerBankAccount;

    @ApiModelProperty(value = "销方地址")
    private String sellerAddr;

    @ApiModelProperty(value = "销方电话")
    private String sellerTel;

   @ApiModelProperty(value = "银行账号")
    private String hiddenAccount;

    @ApiModelProperty(value = "创建账号")
    private Long createUserId;

   @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新账号")
    private Long updateUserId;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }
}
