/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.redletter.enums;

import com.xforceplus.phoenix.redletter.enums.ValueEnum;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public enum RedConfirmationSpecialInvoiceFlag implements ValueEnum<String>
{
    NONE("", "", ""),
    DEFAULT("0", "", ""),
    OIL("2", "\u6210\u54c1\u6cb9", "01"),
    VEHICLE("4", "\u673a\u52a8\u8f66", "14"),
    BUILDING("5", "\u5efa\u7b51\u670d\u52a1", "03"),
    CARGO_TRANSPORT("6", "\u8d27\u7269\u8fd0\u8f93\u670d\u52a1", "04"),
    PROPERTY_SALE("7", "\u4e0d\u52a8\u4ea7\u9500\u552e", "05"),
    PROPERTY_RENT("8", "\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1", "06"),
    MINERALS("9", "\u77ff\u4ea7\u54c1", ""),
    PRODUCT_SALE("10", "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e", "12"),
    SCRAPPED_PRODUCT_ACQUISITION("11", "\u62a5\u5e9f\u4ea7\u54c1\u6536\u8d2d", "24"),
    AGRICULTURAL_PRODUCT_ACQUISITION("12", "\u519c\u4ea7\u54c1\u6536\u8d2d", "16"),
    GOLD_WHOLE_SALE("60", "\u91d1\u94f6\u9996\u9970\u6279\u53d1", "26"),
    GOLD_RETAIL("61", "\u91d1\u94f6\u9996\u9970\u96f6\u552e", "27");

    private final String value;
    private final String description;
    private final String taxWareValue;

    public static boolean needQuerySpecialInfo(String specialInvoiceFlag) {
        return BUILDING.getValue().equals(specialInvoiceFlag) || CARGO_TRANSPORT.getValue().equals(specialInvoiceFlag) || PROPERTY_SALE.getValue().equals(specialInvoiceFlag) || PROPERTY_RENT.getValue().equals(specialInvoiceFlag) || SCRAPPED_PRODUCT_ACQUISITION.getValue().equals(specialInvoiceFlag);
    }

    public static boolean isAppliedByPurchaser(Integer specialInvoiceFlag) {
        return Integer.valueOf(SCRAPPED_PRODUCT_ACQUISITION.getValue()).equals(specialInvoiceFlag) || Integer.valueOf(AGRICULTURAL_PRODUCT_ACQUISITION.getValue()).equals(specialInvoiceFlag);
    }

    public static Optional<RedConfirmationSpecialInvoiceFlag> getEnumByTaxWareValue(String taxWareValue) {
        return StringUtils.isBlank((CharSequence)taxWareValue) ? Optional.empty() : EnumUtils.getEnumList(RedConfirmationSpecialInvoiceFlag.class).stream().filter(r -> r.getTaxWareValue().equals(taxWareValue)).findFirst();
    }

    private RedConfirmationSpecialInvoiceFlag(String value, String description, String taxWareValue) {
        this.value = value;
        this.description = description;
        this.taxWareValue = taxWareValue;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTaxWareValue() {
        return this.taxWareValue;
    }
}

