/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.rednotification.model;

import com.xforceplus.phoenix.rednotification.enums.ResponseCode;
import io.swagger.annotations.ApiModel;

@ApiModel
public class BaseResponse<T> {
    private String code;
    private String message;
    private String traceId;
    private T result;

    public BaseResponse() {
    }

    public BaseResponse(ResponseCode responseCode, T result) {
        this.code = responseCode.getValue();
        this.message = responseCode.getMessage();
        this.result = result;
    }

    public BaseResponse(ResponseCode responseCode, String message, T result) {
        this.code = responseCode.getValue();
        this.message = message;
        this.result = result;
    }

    public static <T> BaseResponse<T> ok() {
        return BaseResponse.ok(null);
    }

    public static <T> BaseResponse<T> ok(T result) {
        return new BaseResponse<T>(ResponseCode.SUCCESS, result);
    }

    public static <T> BaseResponse<T> failed(String message) {
        return new BaseResponse<Object>(ResponseCode.FAIL, message, null);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public T getResult() {
        return this.result;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setResult(T result) {
        this.result = result;
    }
}

