/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.retail.bdt.common.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.xforceplus.retail.bdt.common.data.Page;
import com.xforceplus.retail.bdt.common.utils.BeanUtils;
import com.xforceplus.retail.bdt.common.utils.ChangeChar;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public class BaseController {
    public Page listDataConvert(IPage dbPage, Class queryClass) {
        List records = dbPage.getRecords();
        List respList = BeanUtils.copyList(records, queryClass);
        Page requestPage = new Page();
        requestPage = this.convertPage(dbPage, requestPage);
        requestPage.setRecords(respList);
        return requestPage;
    }

    public Page listDataConvert(org.springframework.data.domain.Page dbPage, Class queryClass) {
        Page respPage = this.convertPage(dbPage);
        List respList = BeanUtils.copyList(dbPage.getContent(), queryClass);
        respPage.setRecords(respList);
        return respPage;
    }

    public Page convertPage(org.springframework.data.domain.Page dbPage) {
        Page page = new Page();
        page.setCurrent(dbPage.getNumber() + 1);
        page.setPages(dbPage.getTotalPages());
        page.setTotal(dbPage.getTotalElements());
        page.setRecords(dbPage.getContent());
        page.setSize(dbPage.getSize());
        if (dbPage.getSort().isSorted()) {
            Sort sort = dbPage.getSort();
            sort.get().forEach(v -> {
                boolean asc = false;
                if (v.getDirection() == Sort.Direction.ASC) {
                    asc = true;
                }
                page.getOrders().add(new com.xforceplus.retail.bdt.common.data.OrderItem(v.getProperty(), asc));
            });
        }
        return page;
    }

    public Page convertPage(IPage dbPage, Page page) {
        BeanUtils.copyProperties((Object)dbPage, page);
        return page;
    }

    public PageRequest convertPage(Page page) {
        List<com.xforceplus.retail.bdt.common.data.OrderItem> orders = page.getOrders();
        ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>();
        for (com.xforceplus.retail.bdt.common.data.OrderItem order : orders) {
            if (StringUtils.isEmpty((Object)order.getColumn())) continue;
            if (order.isAsc()) {
                orderList.add(new Sort.Order(Sort.Direction.ASC, order.getColumn()));
                continue;
            }
            orderList.add(new Sort.Order(Sort.Direction.DESC, order.getColumn()));
        }
        PageRequest pageRequest = PageRequest.of((int)((int)page.getCurrent() - 1), (int)((int)page.getSize()));
        if (!orderList.isEmpty()) {
            pageRequest = PageRequest.of((int)((int)page.getCurrent() - 1), (int)((int)page.getSize()), (Sort)Sort.by(orderList));
        }
        return pageRequest;
    }

    public com.baomidou.mybatisplus.extension.plugins.pagination.Page convertPlusPage(Page page) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page dbPage = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(page.getCurrent(), page.getSize());
        List<com.xforceplus.retail.bdt.common.data.OrderItem> orders = page.getOrders();
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        for (com.xforceplus.retail.bdt.common.data.OrderItem order : orders) {
            if (StringUtils.isEmpty((Object)order.getColumn())) continue;
            OrderItem orderItem = new OrderItem();
            orderItem.setAsc(order.isAsc());
            orderItem.setColumn(ChangeChar.humpToLine(order.getColumn()));
            orderItems.add(orderItem);
        }
        dbPage.setOrders(orderItems);
        return dbPage;
    }

    public <T> T getDataConvert(Object model, Class<T> queryClass) {
        return BeanUtils.copyProperties(model, queryClass);
    }
}

