/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.retail.bdt.common.response;

import com.xforceplus.retail.bdt.common.response.ResultCode;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

public class BaseResult<T>
implements Serializable {
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private int status;
    @ApiModelProperty(value="\u63d0\u793a\u4fe1\u606f")
    private String message;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u7cfb\u7edf\u65f6\u95f4")
    private long serverTime = System.currentTimeMillis();
    public static final BaseResult<String> SUCCESS = new BaseResult(ResultCode.SUCCESS);

    public static BaseResult<String> success() {
        return new BaseResult<String>();
    }

    public static <T> BaseResult<T> success(T t) {
        return new BaseResult<T>(t);
    }

    public static BaseResult<String> error() {
        return new BaseResult<String>(ResultCode.SYSTEM_INNER_ERROR);
    }

    public static BaseResult<String> error(ResultCode resultCodeEnum) {
        return new BaseResult<String>(resultCodeEnum);
    }

    private BaseResult() {
        this(ResultCode.SUCCESS);
    }

    private BaseResult(T t) {
        this(ResultCode.SUCCESS, t);
    }

    private BaseResult(ResultCode resultCode) {
        this(resultCode, null);
    }

    private BaseResult(ResultCode resultCode, T t) {
        this(resultCode.code(), resultCode.message(), t);
    }

    public BaseResult(int status, String message) {
        this(status, message, null);
    }

    private BaseResult(int status, String message, T t) {
        this.status = status;
        this.message = message;
        this.data = t;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public long getServerTime() {
        return this.serverTime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setServerTime(long serverTime) {
        this.serverTime = serverTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResult)) {
            return false;
        }
        BaseResult other = (BaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        return this.getServerTime() == other.getServerTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        long $serverTime = this.getServerTime();
        result = result * 59 + (int)($serverTime >>> 32 ^ $serverTime);
        return result;
    }

    public String toString() {
        return "BaseResult(status=" + this.getStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", serverTime=" + this.getServerTime() + ")";
    }
}

