/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.retail.bdt.common.utils;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;

public class DateTimeUtils {
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static LocalDate parseLocalDate(String dateStr) {
        return LocalDate.parse(dateStr, DATE_FORMATTER);
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr) {
        return LocalDateTime.parse(dateTimeStr, DATETIME_FORMATTER);
    }

    public static LocalTime parseLocalTime(String timeStr) {
        return LocalTime.parse(timeStr, TIME_FORMATTER);
    }

    public static String formatLocalDate(LocalDate date) {
        return date.format(DATE_FORMATTER);
    }

    public static String formatLocalDate(LocalDate date, DateTimeFormatter formatter) {
        return date.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime datetime, DateTimeFormatter formatter) {
        return datetime.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime datetime) {
        return datetime.format(DATETIME_FORMATTER);
    }

    public static String formatLocalTime(LocalTime time) {
        return time.format(TIME_FORMATTER);
    }

    public static int periodDays(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return Period.between(startDateInclusive, endDateExclusive).getDays();
    }

    public static long durationHours(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long durationMinutes(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long durationMillis(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static LocalDate getCurrentLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime getCurrentLocalTime() {
        return LocalTime.now();
    }

    public static LocalDateTime get() {
        return LocalDateTime.now();
    }

    public static int getYear() {
        return DateTimeUtils.get().getYear();
    }

    public static LocalDateTime withYear(int year) {
        return DateTimeUtils.get().withYear(year);
    }

    public static int getMonth() {
        return DateTimeUtils.get().getMonthValue();
    }

    public static LocalDateTime firstDayOfThisYear(int year) {
        return DateTimeUtils.withYear(year).with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
    }

    public static String getFirstDayOfThisYear(int year) {
        LocalDateTime firstDayOfThisYear = DateTimeUtils.firstDayOfThisYear(year);
        return DATETIME_FORMATTER.format(firstDayOfThisYear);
    }

    public static LocalDateTime lastDayOfThisYear(int year) {
        return DateTimeUtils.withYear(year).with(TemporalAdjusters.lastDayOfYear()).with(LocalTime.MAX);
    }

    public static String getLastDayOfThisYear(int year) {
        LocalDateTime lastDayOfThisYear = DateTimeUtils.lastDayOfThisYear(year);
        return DATETIME_FORMATTER.format(lastDayOfThisYear);
    }

    public static String getFirstDayOfThisMonth() {
        LocalDateTime firstDayOfThisYear = DateTimeUtils.get().with(TemporalAdjusters.firstDayOfMonth());
        return DATETIME_FORMATTER.format(firstDayOfThisYear);
    }

    public static String getLastDayOfThisMonth() {
        LocalDateTime firstDayOfThisYear = DateTimeUtils.get().with(TemporalAdjusters.lastDayOfMonth());
        return DATETIME_FORMATTER.format(firstDayOfThisYear);
    }

    public static LocalDateTime plusDays(int days) {
        return DateTimeUtils.get().plusDays(days);
    }

    public static LocalDateTime firstDayOfWeekInYearMonth(int year, int month) {
        return DateTimeUtils.get().withYear(year).withMonth(month).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY));
    }

    public static LocalDateTime todayStart() {
        return LocalDateTime.of(DateTimeUtils.getCurrentLocalDate(), LocalTime.MIN);
    }

    public static LocalDateTime todayEnd() {
        return LocalDateTime.of(DateTimeUtils.getCurrentLocalDate(), LocalTime.MAX);
    }

    public static String getStartDayOfWeekToString() {
        return DateTimeUtils.formatLocalDate(DateTimeUtils.getStartDayOfWeek());
    }

    public static LocalDate getStartDayOfWeek() {
        TemporalAdjuster FIRST_OF_WEEK = TemporalAdjusters.ofDateAdjuster(localDate -> localDate.minusDays(localDate.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue()));
        return DateTimeUtils.getCurrentLocalDate().with(FIRST_OF_WEEK);
    }

    public static String getEndDayOfWeekToString() {
        return DateTimeUtils.formatLocalDate(DateTimeUtils.getEndDayOfWeek());
    }

    public static LocalDate getEndDayOfWeek() {
        TemporalAdjuster LAST_OF_WEEK = TemporalAdjusters.ofDateAdjuster(localDate -> localDate.plusDays(DayOfWeek.SUNDAY.getValue() - localDate.getDayOfWeek().getValue()));
        return DateTimeUtils.getCurrentLocalDate().with(LAST_OF_WEEK);
    }

    public static void main(String[] args) {
        Integer year = 2019;
        System.out.println(DateTimeUtils.getFirstDayOfThisYear(year));
        System.out.println(DateTimeUtils.getLastDayOfThisYear(year));
        System.out.println(DATETIME_FORMATTER.format(DateTimeUtils.plusDays(1)));
        System.out.println(DATETIME_FORMATTER.format(DateTimeUtils.plusDays(-1)));
        LocalDate ld = LocalDate.parse("2019-01-01").with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY));
        System.out.println(DATE_FORMATTER.format(ld));
        System.out.println(DATETIME_FORMATTER.format(DateTimeUtils.firstDayOfWeekInYearMonth(year, 3)));
        System.out.println("-------------------");
        System.out.println(DateTimeUtils.getStartDayOfWeekToString());
        System.out.println(DateTimeUtils.getEndDayOfWeekToString());
        System.out.println("-------------------");
        System.out.println(DATETIME_FORMATTER.format(DateTimeUtils.todayStart()));
        System.out.println(DATETIME_FORMATTER.format(DateTimeUtils.todayEnd()));
        System.out.println(">>>>>>>>>>>>>");
        System.out.println(DateTimeUtils.formatLocalDate(LocalDate.now()));
        System.out.println(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }
}

