/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.retail.bdt.common.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class DateUtils {
    public static Function<String, String> datacollects = key -> {
        switch (key) {
            case "DT1": {
                return DateUtils.getUtcTimeFromNow();
            }
            case "DT2": {
                return DateUtils.getSimpleDateTime();
            }
            case "DN": {
                return DateUtils.getSimpleDate();
            }
            case "DMP": {
                return DateUtils.getPreMonthSimpleDate();
            }
            case "DP": {
                return DateUtils.getPreSimpleDate();
            }
            case "LDT": {
                return DateUtils.getCurrentTimeStamp();
            }
            case "DTP": {
                return DateUtils.getPreTwoSimpleDate();
            }
        }
        return "";
    };

    public static String getUtcTimeFromNow() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withLocale(Locale.getDefault()).withZone(ZoneId.of("UTC"));
        return formatter.format(now);
    }

    public static String getSimpleDateTime() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(now);
    }

    public static String getSimpleDate() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(now);
    }

    public static String getPreSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getPreTwoSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getPreMonthSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getCurrentTimeStamp() {
        LocalDate today = LocalDate.now();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        return second.toString();
    }

    public static int getMDayCurDayBeforeTwoDay() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        return preDate.getDayOfMonth();
    }

    public static int getMonthCurDayBeforeTwoDay() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        return preDate.getMonth().getValue();
    }

    public static String transDate(String origin) {
        return origin.replaceAll("\\/", "-");
    }

    public static Date stampToDate(long stamp) {
        Instant instant = Instant.ofEpochMilli(stamp);
        return Date.from(instant);
    }

    public static Long dateToStamp(Date date) {
        Instant instant = date.toInstant();
        return instant.toEpochMilli();
    }

    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String dateToStrLong(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String getDateTimeString(String strDateTime) {
        Date dataTime = null;
        if (StringUtils.isEmpty((Object)strDateTime)) {
            boolean isDateTime = Pattern.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}", strDateTime);
            boolean isDate = Pattern.matches("\\d{4}-\\d{1,2}-\\d{1,2}", strDateTime);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (isDateTime) {
                dataTime = DateUtils.strToDateLong(strDateTime);
                return sdf.format(dataTime);
            }
            if (isDate) {
                dataTime = DateUtils.strToDate(strDateTime);
                return sdf.format(dataTime);
            }
        }
        return "";
    }

    public static Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static List<String> getYears(Date startDate, Date endDate) {
        ArrayList<String> yearList = new ArrayList<String>();
        Calendar min = Calendar.getInstance();
        min.setTime(startDate);
        Calendar max = Calendar.getInstance();
        max.setTime(endDate);
        Integer startYear = min.get(1);
        Integer endYear = max.get(1);
        while (startYear <= endYear) {
            yearList.add(startYear.toString());
            Integer n = startYear;
            Integer n2 = startYear = Integer.valueOf(startYear + 1);
        }
        return yearList;
    }

    public static List<String> getMonths(Date startDate, Date endDate, String format) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String defaultFormat = "yyyy-MM";
            if (StringUtils.isEmpty((Object)format)) {
                format = defaultFormat;
            }
            String minDate = DateUtils.dateToStr(startDate);
            String maxDate = DateUtils.dateToStr(endDate);
            SimpleDateFormat sdf = new SimpleDateFormat(defaultFormat);
            Calendar min = Calendar.getInstance();
            Calendar max = Calendar.getInstance();
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
            sdf = new SimpleDateFormat(format);
            Calendar curr = min;
            while (curr.before(max)) {
                result.add(sdf.format(curr.getTime()));
                curr.add(2, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String> getWeeks(Date startDate, Date endDate, String format) {
        String defaultFormat = "%s-%s";
        if (!StringUtils.isEmpty((Object)format)) {
            defaultFormat = format;
        }
        ArrayList<String> weekList = new ArrayList<String>();
        String startWeekStr = DateUtils.getWeek(startDate, null);
        String[] startSplit = startWeekStr.split("-");
        weekList.add(String.format(defaultFormat, startSplit[0], startSplit[1]));
        String endWeekStr = DateUtils.getWeek(endDate, null);
        int end = Integer.parseInt(endWeekStr.replace("-", ""));
        int start = Integer.parseInt(startWeekStr.replace("-", ""));
        String[] arrStr = startWeekStr.split("-");
        Integer year = Integer.parseInt(arrStr[0]);
        Integer week = Integer.parseInt(arrStr[1]);
        while (start < end) {
            Integer n;
            Integer n2;
            if (week < 52) {
                n2 = week;
                n = week = Integer.valueOf(week + 1);
            } else {
                n2 = year;
                n = year = Integer.valueOf(year + 1);
                week = 1;
            }
            String weekStr = week.toString().length() == 1 ? "0" + week : week.toString();
            String yearWeekStr = String.format(defaultFormat, year, weekStr);
            weekList.add(yearWeekStr);
            start = Integer.parseInt(year + weekStr);
        }
        return weekList;
    }

    public static List<String> getDays(Date startDate, Date endDate, String format) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String defaultFormat = "yyyy-MM-dd";
            if (StringUtils.isEmpty((Object)format)) {
                format = defaultFormat;
            }
            String minDate = DateUtils.dateToStr(startDate);
            String maxDate = DateUtils.dateToStr(endDate);
            SimpleDateFormat sdf = new SimpleDateFormat(defaultFormat);
            Calendar min = Calendar.getInstance();
            Calendar max = Calendar.getInstance();
            min.setTime(sdf.parse(minDate));
            max.setTime(sdf.parse(maxDate));
            sdf = new SimpleDateFormat(format);
            Calendar curr = min;
            while (curr.before(max)) {
                result.add(sdf.format(curr.getTime()));
                curr.add(5, 1);
            }
            result.add(sdf.format(max.getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getWeek(Date date, String format) {
        String defaultFormat = "%s-%s";
        if (!StringUtils.isEmpty((Object)format)) {
            defaultFormat = format;
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        Integer week = ca.get(3);
        return String.format(defaultFormat, ca.get(1), week.toString().length() > 1 ? week : "0" + week);
    }

    public static void main(String[] args) {
        List<String> list = null;
        String startStr = "2019-01-09";
        String endStr = "2019-02-29";
        Date startDate = DateUtils.strToDate(startStr);
        Date endDate = DateUtils.strToDate(endStr);
        list = DateUtils.getWeeks(startDate, endDate, null);
        System.out.println(list);
        System.out.println(DateUtils.getMonths(startDate, endDate, "yyyy.MM"));
        System.out.println(DateUtils.getYears(startDate, endDate));
        System.out.println(DateUtils.getDays(startDate, endDate, "yyyy.MM.dd"));
    }
}

