/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.retail.ucenter;

import com.xforceplus.retail.ucenter.RetailUserInfo;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.ICompany;
import com.xforceplus.tenantsecurity.domain.IOrg;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class RetailUserContext {
    public static IAuthorizedUser getAuthorizedUser() {
        return UserInfoHolder.get();
    }

    public static RetailUserInfo user() {
        RetailUserInfo retailUserInfo = new RetailUserInfo();
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            return retailUserInfo;
        }
        retailUserInfo.setUserId(authorizedUser.getId());
        retailUserInfo.setTenantId(authorizedUser.getTenantId());
        retailUserInfo.setTenantName(authorizedUser.getTenantName());
        if (null != authorizedUser.getCurrentOrgs() && !authorizedUser.getCurrentOrgs().isEmpty()) {
            retailUserInfo.setOrgId(((IOrg)authorizedUser.getCurrentOrgs().get(0)).getOrgId());
            retailUserInfo.setOrgIds(authorizedUser.getCurrentOrgs().stream().map(v -> v.getOrgId()).collect(Collectors.toList()));
        }
        if (null != authorizedUser.getParentCompanies() && !authorizedUser.getParentCompanies().isEmpty()) {
            ArrayList companies = new ArrayList(authorizedUser.getParentCompanies());
            retailUserInfo.setCompanyId(((ICompany)companies.get(0)).getCompanyId());
        }
        retailUserInfo.setAccountId(authorizedUser.getAccountId());
        retailUserInfo.setEmail(authorizedUser.getEmail());
        retailUserInfo.setUsername(authorizedUser.getUsername());
        retailUserInfo.setMobile(authorizedUser.getMobile());
        return retailUserInfo;
    }
}

