/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.cache;

import com.alibaba.fastjson.JSON;
import com.xforceplus.phoenix.risk.client.OrgApiClient;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoResponse;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalUcenterCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_NANME = "UCENTER_LOCAL_CACHE";
    @Autowired
    private OrgApiClient orgApiClient;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    @Cacheable(cacheNames={"UCENTER_LOCAL_CACHE"}, key="#root.args[0]+#root.args[1]")
    public GetOrgListResponse getOrgList(Long groupId, Long userId, String applicationName) {
        GetOrgListRequest params = new GetOrgListRequest();
        params.setAppid(applicationName);
        params.setRid(UUID.randomUUID().toString().replace("-", ""));
        params.setGroupID(groupId);
        params.setUserID(userId);
        params.setPage(Integer.valueOf(0));
        params.setRow(Integer.valueOf(2000));
        this.logger.info("invoker orgApiClient.getOrgList, param = {}", (Object)JSON.toJSONString((Object)params));
        this.printUserHolder();
        GetOrgListResponse response = this.orgApiClient.getOrgList(params);
        this.logger.info("invoker orgApiClient.getOrgList response = {}", (Object)JSON.toJSONString((Object)response));
        return response;
    }

    @Cacheable(cacheNames={"UCENTER_LOCAL_CACHE"})
    public List<OrgModel> getOrgList(Long groupId, Long userId, Integer orgType, String companyNo) {
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(groupId);
        request.setUserID(userId);
        request.setAppid("phoenix-seller-invoice");
        request.setRid(UUID.randomUUID().toString());
        if (orgType != null) {
            request.setSingleOrgType(orgType);
        }
        request.setQueryBelongToCountFlag(Boolean.valueOf(true));
        request.setCompanyNo(companyNo);
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        this.logger.debug("======================getOrgList-request-{}============================", (Object)request);
        this.printUserHolder();
        GetOrgListResponse response = this.orgApiClient.getOrgList(request);
        List orgModelList = response.getResult();
        this.logger.debug("======================OrgModel-List-{}===================================", (Object)orgModelList);
        return orgModelList;
    }

    @Cacheable(cacheNames={"UCENTER_LOCAL_CACHE"})
    public OrgModel getOrgInfoByOrgCode(Long groupId, GetOrgInfoRequest.DataTypeEnum dataTypeEnum, String value) {
        GetOrgInfoRequest request = new GetOrgInfoRequest();
        request.setDataType(dataTypeEnum);
        request.setDataValue(value);
        request.setGroupID(groupId);
        request.setAppid("phoenix-seller-invoice");
        request.setRid(UUID.randomUUID().toString());
        this.logger.debug("======================getOrgInfoByOrgCode-request-{}============================", (Object)request);
        this.printUserHolder();
        GetOrgInfoResponse orgInfo = this.orgApiClient.getOrgInfo(request);
        OrgModel result = orgInfo.getResult();
        this.logger.debug("======================OrgModel-{}===================================", (Object)result);
        return result;
    }

    private void printUserHolder() {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        this.logger.debug("\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e3a{}-{}:", this.getClass(), (Object)JsonUtils.writeObjectToFastJson((Object)userInfo));
    }
}

