/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.risk.config.CaffeineCacheEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableCaching
@EnableScheduling
public class CaffeineCacheConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @Primary
    public CacheManager caffeineCacheManager() {
        this.logger.info("=======================building cacheManager==================================");
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        CaffeineCacheEnum[] caches = CaffeineCacheEnum.values();
        ArrayList cacheList = Lists.newArrayList();
        for (CaffeineCacheEnum c : caches) {
            cacheList.add(new CaffeineCache(c.getCacheName(), Caffeine.newBuilder().recordStats().expireAfterWrite((long)c.getTtl(), TimeUnit.SECONDS).maximumSize((long)c.getMaxSize()).build()));
        }
        cacheManager.setCaches((Collection)cacheList);
        return cacheManager;
    }
}

