/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.core.controller;

import com.xforceplus.phoenix.risk.ApiVersion.ApiV1RiskApp;
import com.xforceplus.phoenix.risk.api.BlackCollectionApi;
import com.xforceplus.phoenix.risk.client.model.MsAddBlackCollectInfo;
import com.xforceplus.phoenix.risk.client.model.MsBlackListResponse;
import com.xforceplus.phoenix.risk.client.model.MsBlackResult;
import com.xforceplus.phoenix.risk.core.BlackCollectService;
import com.xforceplus.phoenix.risk.vo.BlackByKeyWordRequest;
import com.xforceplus.phoenix.risk.vo.MSBlackQueryRequest;
import com.xforceplus.phoenix.risk.vo.MsBlackDeleteRequest;
import com.xforceplus.phoenix.risk.vo.MsModifyBlackRequest;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@ApiV1RiskApp
@Api(tags={"Black-Collect"})
public class BlackCollectionApiController
extends BaseAppController
implements BlackCollectionApi {
    @Autowired
    private BlackCollectService blackCollectService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    @Override
    public Response<MsBlackResult> queryBlackListCollects(@RequestBody MSBlackQueryRequest request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        String blackName = request.getBlackName();
        Integer pageNo = request.getPageNo();
        Integer pageSize = request.getPageSize();
        Long sysOrgId = request.getSysOrgId();
        return this.blackCollectService.queryBlackListCollects(sysOrgId, blackName, tenantId, pageNo, pageSize);
    }

    @Override
    public MsBlackListResponse addBlackCollectionInfo(@RequestBody MsAddBlackCollectInfo request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        return this.blackCollectService.addBlackCollectionInfo(request, tenantId);
    }

    @Override
    public MsBlackListResponse deleteAllBlackCollectionInfo(@RequestBody MsBlackDeleteRequest request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        return this.blackCollectService.deleteAllBlackCollectionInfo(request.getIds(), tenantId);
    }

    @Override
    public MsBlackListResponse modifyBlackCollection(@RequestBody MsModifyBlackRequest request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        Long id = request.getId();
        return this.blackCollectService.modifyBlackCollection(request, tenantId, id);
    }

    @Override
    public MsBlackListResponse getBlackListByKeyWord(@RequestBody @ApiParam(value="\u8bf7\u6c42", required=true) BlackByKeyWordRequest request) {
        return this.blackCollectService.getBlackListByKeyWord(request);
    }
}

