/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.core.controller;

import com.xforceplus.phoenix.risk.ApiVersion.ApiV1RiskApp;
import com.xforceplus.phoenix.risk.api.BlacklistApi;
import com.xforceplus.phoenix.risk.client.model.MsAddBlackListInfo;
import com.xforceplus.phoenix.risk.client.model.MsBlackListResponse;
import com.xforceplus.phoenix.risk.client.model.MsBlackListResultResponse;
import com.xforceplus.phoenix.risk.client.model.MsExportBlackRequest;
import com.xforceplus.phoenix.risk.client.model.MsImportRecordListDataRequest;
import com.xforceplus.phoenix.risk.client.model.MsUpdateBlackListInfo;
import com.xforceplus.phoenix.risk.core.BlacklistService;
import com.xforceplus.phoenix.risk.vo.MsBlackListQueryRequest;
import com.xforceplus.phoenix.risk.vo.MsDeleteBlackRequest;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@ApiV1RiskApp
@Api(tags={"Black-List"})
public class BlacklistApiController
extends BaseAppController
implements BlacklistApi {
    @Autowired
    private BlacklistService blacklistService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    @Override
    public MsBlackListResponse addBlackListInfo(@RequestBody MsAddBlackListInfo request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        return this.blacklistService.addBlackListInfo(request, tenantId);
    }

    @Override
    public MsBlackListResponse deleteBlackListInfo(@RequestBody MsDeleteBlackRequest request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        return this.blacklistService.deleteBlackListInfo(request.getIds(), tenantId);
    }

    @Override
    public MsBlackListResultResponse getBlackListByCollectId(@RequestBody MsBlackListQueryRequest request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        Long id = request.getId();
        String companyName = request.getBlackCompanyName();
        Integer pageSize = request.getPageSize();
        Integer pageNo = request.getPageNo();
        return this.blacklistService.getBlackListByCollectId(tenantId, id, pageNo, pageSize, companyName);
    }

    @Override
    public MsBlackListResponse importBlackListData(@RequestBody MsImportRecordListDataRequest request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        return this.blacklistService.importBlackListData(request, tenantId);
    }

    @Override
    public MsBlackListResponse updateBlackListInfo(@RequestBody MsUpdateBlackListInfo request) {
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        Long id = request.getUpdateParam().getId();
        return this.blacklistService.updateBlackListInfo(request, tenantId, id);
    }

    @Override
    public MsBlackListResponse exportBlacklist(@ApiParam(value="request", required=true) @RequestBody MsExportBlackRequest request) {
        return this.blacklistService.exportBlacklist(request);
    }
}

