/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.risk.client.BlackCollectionClient;
import com.xforceplus.phoenix.risk.client.model.MsAddBlackCollectInfo;
import com.xforceplus.phoenix.risk.client.model.MsBlackByKeyWordRequest;
import com.xforceplus.phoenix.risk.client.model.MsBlackListResponse;
import com.xforceplus.phoenix.risk.client.model.MsBlackResult;
import com.xforceplus.phoenix.risk.core.BlackCollectService;
import com.xforceplus.phoenix.risk.external.SysOrgServiceImpl;
import com.xforceplus.phoenix.risk.vo.BlackByKeyWordRequest;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlackCollectServiceImpl
implements BlackCollectService {
    @Autowired
    private BlackCollectionClient blackCollectionClient;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    SysOrgServiceImpl sysOrgServiceImpl;

    @Override
    public Response<MsBlackResult> queryBlackListCollects(Long sysOrgId, String blackName, Long tenantId, Integer pageNo, Integer pageSize) {
        return this.blackCollectionClient.queryBlackListCollects(sysOrgId, blackName, tenantId, pageNo, pageSize);
    }

    @Override
    public MsBlackListResponse addBlackCollectionInfo(MsAddBlackCollectInfo request, Long tenantId) {
        request.setCreateUserName(((UserInfo)this.userInfoHolder.get()).getUserName());
        request.setCreateUserId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
        request.setTenantCode(((UserInfo)this.userInfoHolder.get()).getGroupCode());
        request.setOwnOrgName(((UserInfo)this.userInfoHolder.get()).getGroupName());
        request.setUpdateUserName(((UserInfo)this.userInfoHolder.get()).getUserName());
        request.setUpdateUserId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
        return this.blackCollectionClient.addBlackCollectionInfo(request, tenantId);
    }

    @Override
    public MsBlackListResponse deleteAllBlackCollectionInfo(List<Long> ids, Long tenantId) {
        return this.blackCollectionClient.deleteAllBlackCollectionInfo(ids, tenantId);
    }

    @Override
    public MsBlackListResponse modifyBlackCollection(MsAddBlackCollectInfo request, Long tenantId, Long id) {
        request.setUpdateUserName(((UserInfo)this.userInfoHolder.get()).getUserName());
        request.setUpdateUserId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
        return this.blackCollectionClient.modifyBlackCollection(request, tenantId, id);
    }

    @Override
    public MsBlackListResponse getBlackListByKeyWord(BlackByKeyWordRequest request) {
        MsBlackByKeyWordRequest msRequest = new MsBlackByKeyWordRequest();
        msRequest.setKeyWords((List)Lists.newArrayList((Object[])new String[]{request.getKeyWord()}));
        msRequest.setSysOrgIds(request.getSysOrgIds());
        msRequest.setTenantId(request.getTenantId());
        return this.blackCollectionClient.getBlackListByKeyWord(msRequest);
    }
}

