/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.GroupModel;
import com.xforceplus.bss.external.client.model.SearchGroupListResponse;
import com.xforceplus.phoenix.risk.client.GroupApiClient;
import com.xforceplus.phoenix.risk.client.OrgApiClient;
import com.xforceplus.phoenix.risk.vo.CommonQueryCompanyRequest;
import com.xforceplus.phoenix.risk.vo.MsEnumBean;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchFilterService {
    private static final int PAGENO = 1;
    private static final int PAGESIZE = 20;
    @Autowired
    private GroupApiClient groupApiClient;
    @Autowired
    private OrgApiClient orgApiClient;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    public static List<MsEnumBean> groupResponseTrans2EnumBean(List<OrgModel> models, String keyworde) {
        ArrayList msEnumBeans = Lists.newArrayList();
        String key = StringUtils.isBlank((CharSequence)keyworde) ? "" : keyworde;
        for (OrgModel orgTree : models) {
            if (orgTree.getOrgName() == null || orgTree.getOrgName().indexOf(key) <= -1) continue;
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setText(orgTree.getOrgName());
            msEnumBean.setValue(String.valueOf(orgTree.getOrgStructId()));
            msEnumBeans.add(msEnumBean);
        }
        return msEnumBeans;
    }

    public Response<List<MsEnumBean>> searchOrg(CommonQueryCompanyRequest commonQueryCompanyRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("recog");
        clientRequest.setRid(UUID.randomUUID().toString());
        clientRequest.setGroupID(Long.valueOf(userInfo.getGroupId()));
        clientRequest.setUserID(Long.valueOf(userInfo.getUserId()));
        clientRequest.setPage(Integer.valueOf(1));
        clientRequest.setRow(Integer.valueOf(1000));
        userInfo.setGroupId(userInfo.getGroupId());
        GetOrgListResponse orgTree = this.orgApiClient.getOrgList(clientRequest);
        Response resp = new Response();
        resp.setCode(Response.OK);
        if (orgTree.getResult() != null && !CollectionUtils.isEmpty((Collection)orgTree.getResult())) {
            List orgTrees = orgTree.getResult();
            List<MsEnumBean> msEnumBeans = SearchFilterService.groupResponseTrans2EnumBean(orgTrees, commonQueryCompanyRequest.getKeyWord());
            resp.setResult(msEnumBeans);
            return resp;
        }
        resp.setResult((Object)Lists.newArrayList());
        return resp;
    }

    public static List<MsEnumBean> groupResponseTrans2EnumBean(SearchGroupListResponse companyListResponse) {
        List groupModels = companyListResponse.getResult();
        ArrayList msEnumBeans = Lists.newArrayList();
        for (GroupModel groupModel : groupModels) {
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setText(groupModel.getGroupName());
            msEnumBean.setValue(String.valueOf(groupModel.getGroupId()));
            msEnumBeans.add(msEnumBean);
        }
        return msEnumBeans;
    }
}

