/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.risk.client.SensitiveCollectionClient;
import com.xforceplus.phoenix.risk.client.model.MsAddSensitiveCollectRequest;
import com.xforceplus.phoenix.risk.client.model.MsApplyCollectionToSysOrgsrequest;
import com.xforceplus.phoenix.risk.client.model.MsGetSensitiveByKeyWordRequest;
import com.xforceplus.phoenix.risk.client.model.MsRecordListCollectsResponse;
import com.xforceplus.phoenix.risk.client.model.MsRecordsListSearchResponse;
import com.xforceplus.phoenix.risk.client.model.MsSenWordsListResponse;
import com.xforceplus.phoenix.risk.client.model.MsSensitiveCollectSearchrequest;
import com.xforceplus.phoenix.risk.client.model.MsSensitiveInfo;
import com.xforceplus.phoenix.risk.client.model.MsUserInfo;
import com.xforceplus.phoenix.risk.client.model.OrgAndSensitiveRelationDTO;
import com.xforceplus.phoenix.risk.client.model.OrgAndSensitiveRelationParentSubDto;
import com.xforceplus.phoenix.risk.core.SensitiveCollectionService;
import com.xforceplus.phoenix.risk.dto.AddSensitiveCollectRequest;
import com.xforceplus.phoenix.risk.external.SysOrgServiceImpl;
import com.xforceplus.phoenix.risk.vo.BlackByKeyWordRequest;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SenSitiveCollectionServiceImpl
implements SensitiveCollectionService {
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    SensitiveCollectionClient sensitiveCollectionClient;
    @Autowired
    SysOrgServiceImpl sysOrgServiceImpl;

    public MsRecordListCollectsResponse<OrgAndSensitiveRelationDTO> querySenWordListCollects(Long applySysOrgId, String sensitiveCollectionName) {
        MsRecordListCollectsResponse response = new MsRecordListCollectsResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (null == applySysOrgId) {
            applySysOrgId = 0L;
        }
        MsSensitiveCollectSearchrequest request = new MsSensitiveCollectSearchrequest();
        request.setApplySysOrgId(applySysOrgId);
        request.setSensitiveCollectionName(sensitiveCollectionName);
        request.setSysOrgIds((List)Lists.newArrayList((Object[])new Long[]{userInfo.getOrgId()}));
        request.setTenantId(Long.valueOf(userInfo.getGroupId()));
        return this.sensitiveCollectionClient.querySenWordListCollects(request);
    }

    @Override
    public MsSenWordsListResponse addSenWordListCollectionInfo(AddSensitiveCollectRequest request) {
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MsAddSensitiveCollectRequest requestParams = new MsAddSensitiveCollectRequest();
        requestParams.setName(request.getName());
        requestParams.setStatus(request.getStatus());
        MsUserInfo msUserInfo = new MsUserInfo();
        msUserInfo.setUserId(Long.valueOf(userInfo.getUserId()));
        msUserInfo.setUserGroupId(Long.valueOf(userInfo.getGroupId()));
        msUserInfo.setUserOrgId(Long.valueOf(userInfo.getOrgId()));
        msUserInfo.setUserName(userInfo.getUserName());
        requestParams.setUserInfo(msUserInfo);
        requestParams.setTenantId(Long.valueOf(userInfo.getGroupId()));
        requestParams.setMsOrgsRequests(request.getMsOrgsRequests());
        requestParams.setMusterId(request.getMusterId());
        requestParams.setTenantCode(userInfo.getGroupCode());
        return this.sensitiveCollectionClient.addSenWordListCollectionInfo(requestParams);
    }

    @Override
    public MsSenWordsListResponse batchApplyCollectionToSysOrgs(List<Long> sysOrgIds, Long musterId) {
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MsApplyCollectionToSysOrgsrequest request = new MsApplyCollectionToSysOrgsrequest();
        MsUserInfo msUserInfo = new MsUserInfo();
        msUserInfo.setUserId(Long.valueOf(userInfo.getUserId()));
        msUserInfo.setUserGroupId(Long.valueOf(userInfo.getGroupId()));
        msUserInfo.setUserOrgId(Long.valueOf(userInfo.getOrgId()));
        msUserInfo.setUserName(userInfo.getUserName());
        request.setUserInfo(msUserInfo);
        request.setMusterId(musterId);
        request.setTenantId(Long.valueOf(userInfo.getGroupId()));
        if (null == musterId) {
            return response.code(Response.Fail).message("\u96c6\u5408\u5fc5\u987b\u9009");
        }
        if (CollectionUtils.isEmpty(sysOrgIds)) {
            return response.code(Response.Fail).message("\u672a\u9009\u62e9\u79df\u6237!");
        }
        return this.sensitiveCollectionClient.batchApplyCollectionToSysOrgs(request);
    }

    @Override
    public MsSenWordsListResponse deleteAllBlackListCollectionInfo(List<Long> musterIds) {
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return this.sensitiveCollectionClient.deleteAllSensitiveCollectionInfo(musterIds);
    }

    @Override
    public MsSenWordsListResponse batchUnbindSenWordCollection(List<Long> ids) {
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isEmpty(ids)) {
            return response.code(Response.Fail).message("\u5e94\u7528\u5173\u7cfb\u4e0d\u5b58\u5728!");
        }
        return this.sensitiveCollectionClient.batchUnbindSenWordCollection(ids);
    }

    @Override
    public MsRecordsListSearchResponse<List<MsSensitiveInfo>> getSenWordListByKeyWord(BlackByKeyWordRequest request) {
        MsGetSensitiveByKeyWordRequest msRequest = new MsGetSensitiveByKeyWordRequest();
        msRequest.setKeyword(request.getKeyWord());
        msRequest.setSysOrgIds(request.getSysOrgIds());
        msRequest.setTenantId(request.getTenantId());
        return this.sensitiveCollectionClient.getSenWordListByKeyWord(msRequest);
    }

    @Override
    public MsRecordListCollectsResponse<OrgAndSensitiveRelationParentSubDto> querySenWordListCollectsRelations(Long applySysOrgId, String sensitiveCollectionName) {
        MsRecordListCollectsResponse response = new MsRecordListCollectsResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (null == applySysOrgId) {
            applySysOrgId = 0L;
        }
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        MsSensitiveCollectSearchrequest request = new MsSensitiveCollectSearchrequest();
        request.setApplySysOrgId(applySysOrgId);
        request.setSysOrgIds((List)Lists.newArrayList((Object[])new Long[]{userInfo.getOrgId()}));
        request.setSensitiveCollectionName(sensitiveCollectionName);
        request.setTenantId(Long.valueOf(tenantId));
        return this.sensitiveCollectionClient.querySenWordListCollectsRelations(request);
    }
}

