/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.core.impl;

import com.xforceplus.phoenix.risk.client.SensitiveWordClient;
import com.xforceplus.phoenix.risk.client.model.MsBlackListResponse;
import com.xforceplus.phoenix.risk.client.model.MsExportBlackRequest;
import com.xforceplus.phoenix.risk.client.model.MsImportWordsDatarequest;
import com.xforceplus.phoenix.risk.client.model.MsRecordListSearchRequest;
import com.xforceplus.phoenix.risk.client.model.MsRecordsListSearchResponse;
import com.xforceplus.phoenix.risk.client.model.MsSenWordsListResponse;
import com.xforceplus.phoenix.risk.client.model.MsSenWordsListResult;
import com.xforceplus.phoenix.risk.client.model.MsSensitiveListInfoRequest;
import com.xforceplus.phoenix.risk.client.model.MsUpdateSenWordsListInfo;
import com.xforceplus.phoenix.risk.client.model.MsUserInfo;
import com.xforceplus.phoenix.risk.client.model.UploadFileRequest;
import com.xforceplus.phoenix.risk.core.SensitiveWordService;
import com.xforceplus.phoenix.risk.dto.DeleteSensitiveRequest;
import com.xforceplus.phoenix.risk.dto.SensitiveListRequest;
import com.xforceplus.phoenix.risk.dto.UpdateSenWordsListInfoRequest;
import com.xforceplus.phoenix.risk.dto.UploadFileRequestDto;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SensitiveWordServiceImpl
implements SensitiveWordService {
    private static final Logger logger = LoggerFactory.getLogger(SensitiveWordServiceImpl.class);
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    SensitiveWordClient sensitiveWordClient;

    @Override
    public MsSenWordsListResponse addSenWordsListInfo(Long musterId, SensitiveListRequest request) {
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        MsSensitiveListInfoRequest serverRequest = new MsSensitiveListInfoRequest();
        serverRequest.setAddParam(request.getAddParam());
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MsUserInfo msUserInfo = new MsUserInfo();
        msUserInfo.setUserId(Long.valueOf(userInfo.getUserId()));
        msUserInfo.setUserGroupId(Long.valueOf(userInfo.getGroupId()));
        msUserInfo.setUserOrgId(Long.valueOf(userInfo.getOrgId()));
        msUserInfo.setUserName(userInfo.getUserName());
        serverRequest.setUserInfo(msUserInfo);
        serverRequest.setMusterId(musterId);
        serverRequest.setTenantId(Long.valueOf(userInfo.getGroupId()));
        return this.sensitiveWordClient.addSenWordsListInfo(serverRequest);
    }

    @Override
    public MsSenWordsListResponse deleteSenWordsListInfo(DeleteSensitiveRequest request) {
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List<Long> sensitiveIds = request.getSensitiveIds();
        if (CollectionUtils.isEmpty(sensitiveIds)) {
            return response.code(Response.Fail).message("\u5220\u9664\u7684\u654f\u611f\u8bcd\u4e0d\u5b58\u5728\uff01");
        }
        return this.sensitiveWordClient.deleteSenWordsListInfo(sensitiveIds);
    }

    @Override
    public MsSenWordsListResponse importSenWordsListData(UploadFileRequestDto request) {
        logger.info("\u654f\u611f\u8bcd\u4e0a\u4f20 {}", (Object)JsonUtils.writeObjectToFastJson((Object)request));
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        MsImportWordsDatarequest serviceRequest = new MsImportWordsDatarequest();
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        BeanUtils.copyProperties((Object)request, (Object)uploadFileRequest);
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        serviceRequest.setRequest(uploadFileRequest);
        serviceRequest.setUserInfo(userInfo);
        return this.sensitiveWordClient.importSenWordsListData(serviceRequest);
    }

    @Override
    public MsSenWordsListResponse updateSenWordsListInfo(UpdateSenWordsListInfoRequest request, Long id, Long musterId) {
        MsUpdateSenWordsListInfo serviceRequest = new MsUpdateSenWordsListInfo();
        MsSenWordsListResponse response = new MsSenWordsListResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MsUserInfo msUserInfo = new MsUserInfo();
        msUserInfo.setUserId(Long.valueOf(userInfo.getUserId()));
        msUserInfo.setUserGroupId(Long.valueOf(userInfo.getGroupId()));
        msUserInfo.setUserOrgId(Long.valueOf(userInfo.getOrgId()));
        msUserInfo.setUserName(userInfo.getUserName());
        serviceRequest.setUserInfo(msUserInfo);
        serviceRequest.setKeyWord(request.getKeyWord());
        serviceRequest.setLevel(request.getLevel());
        serviceRequest.setId(id);
        serviceRequest.setMusterId(musterId);
        serviceRequest.setStatus(request.getStatus());
        return this.sensitiveWordClient.updateSenWordsListInfo(serviceRequest);
    }

    @Override
    public MsRecordsListSearchResponse<MsSenWordsListResult> getSenWordsListByKeyWord(Long musterId, Integer pageNo, Integer pageSize, String keyword) {
        MsRecordsListSearchResponse response = new MsRecordsListSearchResponse();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            return response.code(Response.Fail).message("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MsRecordListSearchRequest request = new MsRecordListSearchRequest();
        request.setCollectId(musterId);
        request.setKeyWord(keyword);
        request.setPageNo(pageNo);
        request.setPageSize(pageSize);
        return this.sensitiveWordClient.getSenWordsListByKeyWord(request);
    }

    @Override
    public MsBlackListResponse exportSensitivelist(MsExportBlackRequest request) {
        MsUserInfo userInfo = new MsUserInfo();
        userInfo.setUserGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        userInfo.setUserOrgId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getOrgId()));
        userInfo.setUserId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
        userInfo.setUserName(((UserInfo)this.userInfoHolder.get()).getUserName());
        request.setUserInfo(userInfo);
        return this.sensitiveWordClient.exportSensitivelist(request);
    }
}

