/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.external;

import com.xforceplus.phoenix.risk.external.CommonResponse;
import com.xforceplus.phoenix.risk.external.LoginRequest;
import com.xforceplus.phoenix.risk.external.LoginResponse;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateTools {
    public static final int FEIGN_CONNECT_TIMEOUT = 2000;
    public static final int FEIGN_READ_TIMEOUT = 180000;
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateTools.class);
    @Autowired
    private RestTemplate restTemplate;
    private final RestTemplate redditFeignRestTemplate;
    @Value(value="${risk.org.client.clientId:}")
    private String clientId;
    @Value(value="${risk.org.client.secret:}")
    private String secret;
    @Value(value="${risk.org.login.url:}")
    private String loginUrl;
    @Value(value="${risk.org.base.url:}")
    private String baseUrl;

    public RestTemplateTools() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setConnectTimeout(2000);
        requestFactory.setReadTimeout(180000);
        requestFactory.setBufferRequestBody(false);
        this.redditFeignRestTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        List list = this.redditFeignRestTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("UTF8"));
            break;
        }
    }

    public <T extends CommonResponse> T postEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("post\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        String requstJson = JsonUtils.writeObjectToFastJson((Object)req);
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)requstJson);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)requstJson, (MultiValueMap)this.getHeader());
            ResponseEntity tResponseEntity = this.restTemplate.postForEntity(req_url, (Object)requestEntity, tClass, new Object[0]);
            CommonResponse body = (CommonResponse)tResponseEntity.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (HttpServerErrorException e) {
            return this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T postEntityByCustomize(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6 post url:{}", (Object)req_url);
        String requstJson = JsonUtils.writeObjectToFastJson((Object)req);
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)requstJson);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)requstJson, (MultiValueMap)this.getHeader());
            ResponseEntity tResponseEntity = this.redditFeignRestTemplate.postForEntity(req_url, (Object)requestEntity, tClass, new Object[0]);
            CommonResponse body = (CommonResponse)tResponseEntity.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (HttpServerErrorException e) {
            return this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T PostSysOrgInfo(Object req, Long userId, String subUrl, Class<T> tClass) {
        subUrl = String.format(subUrl, userId);
        String req_url = this.baseUrl + subUrl;
        logger.info("post\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        String requestJson = JsonUtils.writeObjectToFastJson((Object)req);
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)requestJson);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)requestJson, (MultiValueMap)this.getHeader());
            logger.info("ResponseEntity{}", (Object)req_url);
            logger.info("requestEntity{}", (Object)requestEntity);
            ResponseEntity tResponseEntity = this.restTemplate.postForEntity(req_url, (Object)requestEntity, tClass, new Object[0]);
            if (null == tResponseEntity || null == tResponseEntity.getBody()) {
                logger.info("\u8bf7\u6c42\u7ea2\u5b57\u7ed3\u679c\u4e3a\u7a7a {}", (Object)JsonUtils.writeObjectToFastJson((Object)tResponseEntity));
                return null;
            }
            CommonResponse body = (CommonResponse)tResponseEntity.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (HttpServerErrorException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38 ", (Throwable)e);
            return this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T putEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("put\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)req));
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.PUT, requestEntity, tClass, new Object[0]);
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (HttpServerErrorException e) {
            return this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T patchEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("patch\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)req_url);
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        logger.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)req));
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.PATCH, requestEntity, tClass, new Object[0]);
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (HttpServerErrorException e) {
            return this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T getEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.baseUrl + groupId + subUrl;
        logger.info("get\u8bf7\u6c42:{}", (Object)req_url);
        logger.info("\u8bf7\u6c42:\r\n{}", (Object)JsonUtils.writeObjectToFastJson((Object)req));
        HttpEntity requestEntity = new HttpEntity(req, (MultiValueMap)this.getHeader());
        try {
            ResponseEntity exchange = this.restTemplate.exchange(req_url, HttpMethod.GET, requestEntity, tClass, new Object[0]);
            CommonResponse body = (CommonResponse)exchange.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (HttpServerErrorException e) {
            return this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T getFailResponse(Class<T> tClass, HttpServerErrorException e, String req_url) {
        try {
            String data = e.getResponseBodyAsString();
            CommonResponse commonResponse = (CommonResponse)JsonUtils.writeFastJsonToObject((String)data, CommonResponse.class);
            if (null == commonResponse) {
                logger.error("commonResponse \u4e3a\u7a7a");
            }
            CommonResponse t = (CommonResponse)tClass.newInstance();
            t.setCode(commonResponse.getCode());
            t.setMessage(commonResponse.getMessage());
            t.setTraceId(commonResponse.getTraceId());
            logger.info("post\u5931\u8d25\u8bf7\u6c42url:{},\u5931\u8d25\u539f\u56e0:{}", (Object)req_url, (Object)commonResponse.toString());
            return (T)t;
        }
        catch (InstantiationException e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38IllegalAccessException", (Throwable)e);
        }
        return null;
    }

    public String getAcessToken() {
        LoginRequest loginRequest = new LoginRequest(this.clientId, this.secret);
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)loginRequest, (MultiValueMap)requestHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(this.loginUrl, (Object)requestEntity, LoginResponse.class, new Object[0]);
        logger.info("\u83b7\u53d6token\u7ed3\u679c {}", (Object)JsonUtils.writeObjectToFastJson((Object)response));
        if (null == response || null == response.getBody()) {
            throw new RuntimeException("\u5f53\u524d\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
        }
        LoginResponse body = (LoginResponse)response.getBody();
        if (body.getCode() == 1) {
            return body.getData();
        }
        throw new RuntimeException("\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
    }

    public HttpHeaders getHeader() {
        String token = this.getAcessToken();
        logger.info("\u83b7\u53d6token\u5f00\u59cb");
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        requestHeaders.add("x-app-token", token);
        logger.info("\u7ec4\u5408header\u5b8c\u6210");
        return requestHeaders;
    }
}

