/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.risk.external;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.risk.cache.LocalUcenterCacheManager;
import com.xforceplus.phoenix.risk.dto.MsGetResourceListResponse;
import com.xforceplus.phoenix.risk.dto.MsGetUserExtraInfoReque;
import com.xforceplus.phoenix.risk.external.RestTemplateTools;
import com.xforceplus.phoenix.risk.external.SysOrgService;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysOrgServiceImpl
implements SysOrgService {
    private static final Logger logger = LoggerFactory.getLogger(SysOrgServiceImpl.class);
    private String PARENT_ORG = "user-center/users/%s/orgs?page=1&row=1000";
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private LocalUcenterCacheManager localUcenterCacheManager;
    @Value(value="${spring.profiles.active:}")
    private String profile;
    @Autowired
    private RestTemplateTools restTemplateTools;

    @Override
    public List<Long> getOrgId(Long groupId, Long userId) {
        try {
            GetOrgListResponse response = this.localUcenterCacheManager.getOrgList(groupId, userId, this.applicationName);
            logger.info("response================================={}", (Object)response);
            ArrayList<Long> ids = new ArrayList<Long>(response.getResult().size());
            response.getResult().stream().forEach(item -> ids.add(item.getOrgStructId()));
            if (CollectionUtils.isEmpty(ids) && this.profile.equals("dev")) {
                return Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 22323L});
            }
            return ids;
        }
        catch (Exception e) {
            logger.info("getOrgId================================={}", (Object)e.getMessage());
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(0L);
            return ids;
        }
    }

    public List<Long> getParentOrgId(Long groupId, Long userId) {
        ArrayList ids = Lists.newArrayList();
        MsGetUserExtraInfoReque request = new MsGetUserExtraInfoReque();
        request.setAppId(0);
        request.setCompanies(Boolean.FALSE);
        request.setParentCompanies(Boolean.FALSE);
        request.setCurrentOrgs(Boolean.TRUE);
        request.setOrgs(Boolean.TRUE);
        request.setResources(Boolean.FALSE);
        MsGetResourceListResponse msGetResourceListResponse = this.restTemplateTools.PostSysOrgInfo(request, userId, this.PARENT_ORG, MsGetResourceListResponse.class);
        msGetResourceListResponse.getResult();
        return ids;
    }
}

